package com.zurrtum.create.foundation.item;

import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3954;

public class InventoryCache implements Supplier<class_1263> {
    private final BiPredicate<class_2586, class_2350> filter;
    public final class_3218 world;
    public final class_2350 direction;
    public final class_2338 pos;
    public boolean cached;
    public class_1263 inventory;
    public Supplier<class_1263> getter = this::refresh;

    public InventoryCache(class_3218 world, class_2338 pos, class_2350 direction, BiPredicate<class_2586, class_2350> filter) {
        this.world = world;
        this.direction = direction;
        this.pos = pos;
        this.filter = filter;
    }

    @Override
    public class_1263 get() {
        if (cached) {
            return inventory;
        }
        return inventory = getter.get();
    }

    public void invalidate() {
        cached = false;
        getter = this::refresh;
    }

    private class_1263 refresh() {
        cached = true;
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null && filter != null && !filter.test(blockEntity, direction)) {
            return null;
        }
        if (block instanceof ItemInventoryProvider<?> provider) {
            return provider.getInventory(state, world, pos, blockEntity, direction);
        }
        if (block instanceof class_3954 provider) {
            return provider.method_17680(state, world, pos);
        }
        if (blockEntity instanceof class_1263 inventory) {
            if (blockEntity instanceof class_2595 && block instanceof class_2281 chestBlock) {
                return class_2281.method_17458(chestBlock, state, world, pos, true);
            }
            return inventory;
        }
        getter = AllTransfer.getCacheInventory(world, pos, direction, filter);
        if (getter == null) {
            return null;
        }
        cached = false;
        return getter.get();
    }
}
