package com.zurrtum.create.foundation.recipe.trie;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zurrtum.create.foundation.recipe.RecipeFinder;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.minecraft.class_1860;
import net.minecraft.class_3218;
import net.minecraft.class_4013;
import net.minecraft.class_8786;

public class RecipeTrieFinder {
    private static final Cache<Object, RecipeTrie<class_1860<?>>> CACHED_TRIES = CacheBuilder.newBuilder().build();

    public static RecipeTrie<class_1860<?>> get(
        @NotNull Object cacheKey,
        class_3218 world,
        Predicate<class_8786<? extends class_1860<?>>> conditions
    ) throws ExecutionException {
        return CACHED_TRIES.get(
            cacheKey, () -> {
                List<class_8786<? extends class_1860<?>>> list = RecipeFinder.get(cacheKey, world, conditions);

                RecipeTrie.Builder<class_1860<?>> builder = RecipeTrie.builder();
                for (class_8786<? extends class_1860<?>> recipe : list) {
                    builder.insert(recipe.comp_1933());
                }

                return builder.build();
            }
        );
    }

    public static final class_4013 LISTENER = resourceManager -> CACHED_TRIES.invalidateAll();
}