package com.zurrtum.create.impl.registry;

import com.zurrtum.create.api.registry.SimpleRegistry;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class TagProviderImpl<K, V> implements SimpleRegistry.Provider<K, V> {
    private final class_6862<K> tag;
    private final Function<K, class_6880<K>> holderGetter;
    private final V value;

    public TagProviderImpl(class_6862<K> tag, Function<K, class_6880<K>> holderGetter, V value) {
        this.tag = tag;
        this.holderGetter = holderGetter;
        this.value = value;
    }

    // eye of the beholder? check the nametag, buddy
    public static class_6880<class_2591<?>> getBeHolder(class_2591<?> type) {
        class_2960 key = class_7923.field_41181.method_10221(type);
        if (key == null)
            throw new IllegalStateException("Unregistered BlockEntityType: " + type);

        return class_7923.field_41181.method_10223(key).orElseThrow();
    }

    @Override
    @Nullable
    public V get(K object) {
        class_6880<K> holder = this.holderGetter.apply(object);
        return holder.method_40220(this.tag) ? this.value : null;
    }

    @Override
    public void onRegister(Runnable invalidate) {
        //TODO
        //        NeoForge.EVENT_BUS.addListener((TagsUpdatedEvent event) -> {
        //            if (event.shouldUpdateStaticData()) {
        //                invalidate.run();
        //            }
        //        });
    }
}
