package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;

import java.util.List;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record SequencedAssemblyJunk(float chance, List<ChanceOutput> junks) {
    public static final Codec<SequencedAssemblyJunk> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        Codec.FLOAT.fieldOf("chance").forGetter(SequencedAssemblyJunk::chance),
        ChanceOutput.CODEC.listOf().fieldOf("junks").forGetter(SequencedAssemblyJunk::junks)
    ).apply(instance, SequencedAssemblyJunk::new));
    public static final class_9139<class_9129, SequencedAssemblyJunk> PACKET_CODEC = class_9139.method_56435(
        class_9135.field_48552,
        SequencedAssemblyJunk::chance,
        ChanceOutput.PACKET_CODEC.method_56433(class_9135.method_56363()),
        SequencedAssemblyJunk::junks,
        SequencedAssemblyJunk::new
    );
    public static final Random random = new Random();

    public boolean hasJunk() {
        return random.nextFloat() > chance;
    }

    public class_1799 getJunk() {
        if (junks.isEmpty()) {
            return class_1799.field_8037;
        }
        float totalWeight = 0;
        for (ChanceOutput junk : junks) {
            totalWeight += junk.chance();
        }
        float number = random.nextFloat() * totalWeight;
        for (ChanceOutput junk : junks) {
            number -= junk.chance();
            if (number < 0)
                return junk.stack().method_7972();
        }
        return class_1799.field_8037;
    }
}
