package com.zurrtum.create.infrastructure.items;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public interface BaseSidedInventory extends class_1263 {
    default int[] create$getAvailableSlots(class_2350 side) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default boolean create$canInsert(int slot, class_1799 stack, @Nullable class_2350 dir) {
        throw new RuntimeException("Implemented via Mixin");
    }


    default boolean create$canExtract(int slot, class_1799 stack, class_2350 dir) {
        throw new RuntimeException("Implemented via Mixin");
    }

    @Override
    default int count(class_1799 stack) {
        return count(stack, null);
    }

    @Override
    default int count(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return count(stack, maxAmount, side);
    }

    @Override
    default int count(class_1799 stack, int maxAmount) {
        return count(stack, maxAmount, null);
    }

    @Override
    default int count(class_1799 stack, int maxAmount, class_2350 side) {
        int count = 0;
        for (int slot : create$getAvailableSlots(side)) {
            if (create$canExtract(slot, stack, side)) {
                class_1799 target = method_5438(slot);
                if (target.method_7960()) {
                    continue;
                }
                if (matches(target, stack)) {
                    count += target.method_7947();
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                }
            }
        }
        return count;
    }

    @Override
    default class_1799 count(Predicate<class_1799> predicate) {
        return count(predicate, null);
    }

    @Override
    default class_1799 count(Predicate<class_1799> predicate, class_2350 side) {
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 stack = method_5438(slot);
            if (stack.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, stack, side) && predicate.test(stack)) {
                return onExtract(stack);
            }
        }
        return class_1799.field_8037;
    }

    @Override
    default class_1799 count(Predicate<class_1799> predicate, int maxAmount) {
        return count(predicate, maxAmount, null);
    }

    @Override
    default class_1799 count(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = create$getAvailableSlots(side);
        for (int i = 0, size = slots.length; i < size; i++) {
            int slot = slots[i];
            class_1799 findStack = method_5438(slot);
            if (findStack.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, findStack, side) && predicate.test(findStack)) {
                int count = findStack.method_7947();
                if (count >= maxAmount) {
                    return onExtract(directCopy(findStack, maxAmount));
                }
                for (i = i + 1; i < size; i++) {
                    slot = slots[i];
                    class_1799 stack = method_5438(slot);
                    if (stack.method_7960()) {
                        continue;
                    }
                    if (create$canExtract(slot, stack, side) && matches(stack, findStack)) {
                        count += stack.method_7947();
                        if (count < maxAmount) {
                            continue;
                        }
                        return onExtract(directCopy(findStack, maxAmount));
                    }
                }
                return onExtract(directCopy(findStack, count));
            }
        }
        return class_1799.field_8037;
    }

    @Override
    default int countAll(Predicate<class_1799> predicate, int maxAmount) {
        return countAll(predicate, maxAmount, null);
    }

    @Override
    default int countAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return 0;
        }
        int count = 0;
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 stack = method_5438(slot);
            if (stack.method_7960()) {
                continue;
            }
            if (predicate.test(stack) && create$canExtract(slot, stack, side)) {
                count += stack.method_7947();
                if (count >= maxAmount) {
                    return maxAmount;
                }
            }
        }
        return count;
    }

    @Override
    default class_1799 countAny() {
        return countAny(null);
    }

    @Override
    default class_1799 countAny(class_2350 side) {
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 target = method_5438(slot);
            if (target.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, target, side)) {
                return onExtract(directCopy(target, target.method_7947()));
            }
        }
        return class_1799.field_8037;
    }

    @Override
    default class_1799 countAny(int maxAmount) {
        return extractAny(maxAmount, null);
    }

    @Override
    default class_1799 countAny(int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = create$getAvailableSlots(side);
        for (int i = 0, size = slots.length; i < size; i++) {
            int slot = slots[i];
            class_1799 findStack = method_5438(slot);
            if (findStack.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, findStack, side)) {
                int count = findStack.method_7947();
                if (count >= maxAmount) {
                    return onExtract(directCopy(findStack, maxAmount));
                }
                for (i = i + 1; i < size; i++) {
                    slot = slots[i];
                    class_1799 stack = method_5438(slot);
                    if (stack.method_7960()) {
                        continue;
                    }
                    if (create$canExtract(slot, stack, side) && matches(stack, findStack)) {
                        count += stack.method_7947();
                        if (count < maxAmount) {
                            continue;
                        }
                        return onExtract(directCopy(findStack, maxAmount));
                    }
                }
                return onExtract(directCopy(findStack, count));
            }
        }
        return class_1799.field_8037;
    }

    @Override
    default int countSpace(class_1799 stack) {
        return countSpace(stack, null);
    }

    @Override
    default int countSpace(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return countSpace(stack, maxAmount, side);
    }

    @Override
    default int countSpace(class_1799 stack, int maxAmount) {
        return countSpace(stack, maxAmount, null);
    }

    @Override
    default int countSpace(class_1799 stack, int maxAmount, class_2350 side) {
        int count = 0;
        for (int slot : create$getAvailableSlots(side)) {
            if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                class_1799 target = method_5438(slot);
                if (target.method_7960()) {
                    count += method_58350(stack) - target.method_7947();
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                } else if (matches(target, stack)) {
                    count += target.method_7914() - target.method_7947();
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                }
            }
        }
        return count;
    }

    @Override
    default int countSpace(class_1799 stack, int maxAmount, int start, int end) {
        return countSpace(stack, maxAmount, start, end, null);
    }

    @Override
    default int countSpace(class_1799 stack, int maxAmount, int start, int end, class_2350 side) {
        int count = 0;
        int[] slots = create$getAvailableSlots(side);
        start = findStartIndex(slots, start);
        if (start == -1) {
            return 0;
        }
        end = findEndIndex(slots, start, end);
        if (end == -1) {
            return 0;
        }
        for (int i = start; i <= end; i++) {
            int slot = slots[i];
            if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                class_1799 target = method_5438(slot);
                if (target.method_7960()) {
                    count += method_58350(stack) - target.method_7947();
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                } else if (matches(target, stack)) {
                    count += target.method_7914() - target.method_7947();
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                }
            }
        }
        return count;
    }

    @Override
    default boolean countSpace(List<class_1799> stacks) {
        return countSpace(stacks, null);
    }

    @Override
    default boolean countSpace(List<class_1799> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            return countSpace(stack, count, side) == count;
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            return countSpace(stack, count, side) == count;
        }
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 target = method_5438(slot);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, method_58350(stack));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                return true;
                            }
                        } else {
                            entry.setValue(remaining - insert);
                        }
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    return true;
                                }
                            } else {
                                entry.setValue(remaining - insert);
                            }
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        return false;
    }

    @Override
    default boolean countSpace(List<class_1799> stacks, int start, int end) {
        return countSpace(stacks, start, end, null);
    }

    @Override
    default boolean countSpace(List<class_1799> stacks, int start, int end, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            return countSpace(stack, count, start, end, side) == count;
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            return countSpace(stack, count, start, end, side) == count;
        }
        int[] slots = create$getAvailableSlots(side);
        start = findStartIndex(slots, start);
        if (start == -1) {
            return false;
        }
        end = findEndIndex(slots, start, end);
        if (end == -1) {
            return false;
        }
        for (int i = start; i <= end; i++) {
            int slot = slots[i];
            class_1799 target = method_5438(slot);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, method_58350(stack));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                return true;
                            }
                        } else {
                            entry.setValue(remaining - insert);
                        }
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    return true;
                                }
                            } else {
                                entry.setValue(remaining - insert);
                            }
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        return false;
    }

    @Override
    default int extract(class_1799 stack) {
        return extract(stack, null);
    }

    @Override
    default int extract(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return extract(stack, maxAmount, side);
    }

    @Override
    default int extract(class_1799 stack, int maxAmount) {
        return extract(stack, maxAmount, null);
    }

    @Override
    default int extract(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (int slot : create$getAvailableSlots(side)) {
            if (create$canExtract(slot, stack, side)) {
                class_1799 target = method_5438(slot);
                if (target.method_7960()) {
                    continue;
                }
                if (matches(target, stack)) {
                    int count = target.method_7947();
                    if (count > remaining) {
                        target.method_7939(count - remaining);
                        method_5431();
                        return maxAmount;
                    }
                    method_5447(slot, class_1799.field_8037);
                    if (count == remaining) {
                        method_5431();
                        return maxAmount;
                    }
                    remaining -= count;
                }
            }
        }
        if (remaining == maxAmount) {
            return 0;
        }
        method_5431();
        return maxAmount - remaining;
    }

    @Override
    default class_1799 extract(Predicate<class_1799> predicate, int maxAmount) {
        return extract(predicate, maxAmount, null);
    }

    @Override
    default class_1799 extract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = create$getAvailableSlots(side);
        for (int i = 0, size = slots.length; i < size; i++) {
            int slot = slots[i];
            class_1799 findStack = method_5438(slot);
            if (findStack.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, findStack, side) && predicate.test(findStack)) {
                int count = findStack.method_7947();
                if (count > maxAmount) {
                    findStack.method_7939(count - maxAmount);
                    method_5431();
                    return onExtract(directCopy(findStack, maxAmount));
                }
                method_5447(slot, class_1799.field_8037);
                if (count == maxAmount) {
                    method_5431();
                    return onExtract(findStack);
                }
                int remaining = maxAmount - count;
                for (i = i + 1; i < size; i++) {
                    slot = slots[i];
                    class_1799 stack = method_5438(slot);
                    if (stack.method_7960()) {
                        continue;
                    }
                    if (create$canExtract(slot, stack, side) && matches(stack, findStack)) {
                        count = stack.method_7947();
                        if (count < remaining) {
                            method_5447(slot, class_1799.field_8037);
                            remaining -= count;
                            continue;
                        }
                        if (count == remaining) {
                            method_5447(slot, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        method_5431();
                        findStack.method_7939(maxAmount);
                        return onExtract(findStack);
                    }
                }
                method_5431();
                findStack.method_7939(maxAmount - remaining);
                return onExtract(findStack);
            }
        }
        return class_1799.field_8037;
    }

    @Override
    default class_1799 extract(Predicate<class_1799> predicate) {
        return extract(predicate, null);
    }

    @Override
    default class_1799 extract(Predicate<class_1799> predicate, class_2350 side) {
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 stack = method_5438(slot);
            if (stack.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, stack, side) && predicate.test(stack)) {
                method_5447(slot, class_1799.field_8037);
                method_5431();
                return onExtract(stack);
            }
        }
        return class_1799.field_8037;
    }

    @Override
    default List<class_1799> extract(List<class_1799> stacks) {
        return extract(stacks, null);
    }

    @Override
    default List<class_1799> extract(List<class_1799> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            int extract = extract(stack, side);
            if (count == extract) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - extract));
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            int extract = extract(stack, count, side);
            if (count == extract) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - extract));
        }
        boolean dirty = false;
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 target = method_5438(slot);
            if (target.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, target, side)) {
                ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
                do {
                    Object2IntMap.Entry<class_1799> entry = iterator.next();
                    class_1799 stack = entry.getKey();
                    if (matches(target, stack)) {
                        int count = target.method_7947();
                        int remaining = entry.getIntValue();
                        if (count < remaining) {
                            method_5447(slot, class_1799.field_8037);
                            entry.setValue(remaining - count);
                            break;
                        }
                        if (count == remaining) {
                            method_5447(slot, class_1799.field_8037);
                        } else {
                            target.method_7939(count - remaining);
                        }
                        iterator.remove();
                        if (entries.isEmpty()) {
                            method_5431();
                            return List.of();
                        }
                        dirty = true;
                        break;
                    }
                } while (iterator.hasNext());
            }
        }
        if (dirty) {
            List<class_1799> result = new ArrayList<>(entries.size());
            for (Object2IntMap.Entry<class_1799> entry : entries) {
                class_1799 stack = entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                } else {
                    result.add(directCopy(stack, count));
                }
            }
            method_5431();
            return result;
        } else {
            return stacks;
        }
    }

    @Override
    default int extractAll(Predicate<class_1799> predicate, int maxAmount) {
        return extractAll(predicate, maxAmount, null);
    }

    @Override
    default int extractAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return 0;
        }
        int remaining = maxAmount;
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 stack = method_5438(slot);
            if (stack.method_7960()) {
                continue;
            }
            if (predicate.test(stack) && create$canExtract(slot, stack, side)) {
                int count = stack.method_7947();
                if (count < remaining) {
                    method_5447(slot, class_1799.field_8037);
                    remaining -= count;
                    continue;
                }
                if (count == remaining) {
                    method_5447(slot, class_1799.field_8037);
                } else {
                    stack.method_7939(count - remaining);
                }
                method_5431();
                return maxAmount;
            }
        }
        if (remaining == maxAmount) {
            return 0;
        }
        method_5431();
        return maxAmount - remaining;
    }

    @Override
    default class_1799 extractAny() {
        return extractAny(null);
    }

    @Override
    default class_1799 extractAny(class_2350 side) {
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 target = method_5438(slot);
            if (target.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, target, side)) {
                method_5447(slot, class_1799.field_8037);
                method_5431();
                return onExtract(target);
            }
        }
        return class_1799.field_8037;
    }

    @Override
    default class_1799 extractAny(int maxAmount) {
        return extractAny(maxAmount, null);
    }

    @Override
    default class_1799 extractAny(int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = create$getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; i++) {
            int slot = slots[i];
            class_1799 findStack = method_5438(slot);
            if (findStack.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, findStack, side)) {
                int count = findStack.method_7947();
                if (count > maxAmount) {
                    findStack.method_7939(count - maxAmount);
                    method_5431();
                    return onExtract(directCopy(findStack, maxAmount));
                }
                method_5447(slot, class_1799.field_8037);
                if (count == maxAmount) {
                    method_5431();
                    return onExtract(findStack);
                }
                int remaining = maxAmount - count;
                for (i = i + 1; i < size; i++) {
                    slot = slots[i];
                    class_1799 stack = method_5438(slot);
                    if (stack.method_7960()) {
                        continue;
                    }
                    if (create$canExtract(slot, stack, side) && matches(stack, findStack)) {
                        count = stack.method_7947();
                        if (count < remaining) {
                            method_5447(slot, class_1799.field_8037);
                            remaining -= count;
                            continue;
                        }
                        if (count == remaining) {
                            method_5447(slot, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        method_5431();
                        findStack.method_7939(maxAmount);
                        return onExtract(findStack);
                    }
                }
                method_5431();
                findStack.method_7939(maxAmount - remaining);
                return onExtract(findStack);
            }
        }
        return class_1799.field_8037;
    }

    private int findEndIndex(int[] slots, int start, int end) {
        for (int i = slots.length - 1; i >= start; i--) {
            if (slots[i] <= end) {
                return i;
            }
        }
        return -1;
    }

    private int findStartIndex(int[] slots, int start) {
        for (int i = 0, size = slots.length; i < size; i++) {
            if (slots[i] >= start) {
                return i;
            }
        }
        return -1;
    }

    @Override
    default int insert(class_1799 stack) {
        return insert(stack, null);
    }

    @Override
    default int insert(class_1799 stack, int maxAmount) {
        return insert(stack, maxAmount, null);
    }

    @Override
    default int insert(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return insert(stack, maxAmount, side);
    }

    @Override
    default int insert(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (int slot : create$getAvailableSlots(side)) {
            if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                class_1799 target = method_5438(slot);
                if (target.method_7960()) {
                    int insert = Math.min(remaining, method_58350(stack));
                    method_5447(slot, directCopy(stack, insert));
                    if (remaining == insert) {
                        method_5431();
                        return maxAmount;
                    }
                    remaining -= insert;
                } else if (matches(target, stack)) {
                    int maxCount = target.method_7914();
                    int count = target.method_7947();
                    if (count != maxCount) {
                        int insert = Math.min(remaining, maxCount - count);
                        target.method_7939(count + insert);
                        if (remaining == insert) {
                            method_5431();
                            return maxAmount;
                        }
                        remaining -= insert;
                    }
                }
            }
        }
        if (remaining == maxAmount) {
            return 0;
        }
        method_5431();
        return maxAmount - remaining;
    }

    @Override
    default int insert(class_1799 stack, int maxAmount, int start, int end) {
        return insert(stack, maxAmount, start, end, null);
    }

    @Override
    default int insert(class_1799 stack, int maxAmount, int start, int end, class_2350 side) {
        int remaining = maxAmount;
        int[] slots = create$getAvailableSlots(side);
        start = findStartIndex(slots, start);
        if (start == -1) {
            return 0;
        }
        end = findEndIndex(slots, start, end);
        if (end == -1) {
            return 0;
        }
        for (int i = start; i <= end; i++) {
            int slot = slots[i];
            if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                class_1799 target = method_5438(slot);
                if (target.method_7960()) {
                    int insert = Math.min(remaining, method_58350(stack));
                    method_5447(slot, directCopy(stack, insert));
                    if (remaining == insert) {
                        method_5431();
                        return maxAmount;
                    }
                    remaining -= insert;
                } else if (matches(target, stack)) {
                    int maxCount = target.method_7914();
                    int count = target.method_7947();
                    if (count != maxCount) {
                        int insert = Math.min(remaining, maxCount - count);
                        target.method_7939(count + insert);
                        if (remaining == insert) {
                            method_5431();
                            return maxAmount;
                        }
                        remaining -= insert;
                    }
                }
            }
        }
        if (remaining == maxAmount) {
            return 0;
        }
        method_5431();
        return maxAmount - remaining;
    }

    @Override
    default List<class_1799> insert(List<class_1799> stacks) {
        return insert(stacks, null);
    }

    @Override
    default List<class_1799> insert(List<class_1799> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            int insert = insert(stack, side);
            if (count == insert) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            int insert = insert(stack, count, side);
            if (count == insert) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - insert));
        }
        boolean dirty = false;
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 target = method_5438(slot);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, method_58350(stack));
                        method_5447(slot, directCopy(stack, insert));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                method_5431();
                                return List.of();
                            }
                        } else {
                            entry.setValue(remaining - insert);
                        }
                        dirty = true;
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            target.method_7939(count + insert);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    method_5431();
                                    return List.of();
                                }
                            } else {
                                entry.setValue(remaining - insert);
                            }
                            dirty = true;
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        if (dirty) {
            List<class_1799> result = new ArrayList<>(entries.size());
            for (Object2IntMap.Entry<class_1799> entry : entries) {
                class_1799 stack = entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                } else {
                    result.add(directCopy(stack, count));
                }
            }
            method_5431();
            return result;
        } else {
            return stacks;
        }
    }

    @Override
    default List<class_1799> insert(List<class_1799> stacks, int start, int end) {
        return insert(stacks, start, end, null);
    }

    @Override
    default List<class_1799> insert(List<class_1799> stacks, int start, int end, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            int insert = insert(stack, count, start, end, side);
            if (count == insert) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            int insert = insert(stack, count, start, end, side);
            if (count == insert) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - insert));
        }
        boolean dirty = false;
        int[] slots = create$getAvailableSlots(side);
        start = findStartIndex(slots, start);
        if (start == -1) {
            return stacks;
        }
        end = findEndIndex(slots, start, end);
        if (end == -1) {
            return stacks;
        }
        for (int i = start; i <= end; i++) {
            int slot = slots[i];
            class_1799 target = method_5438(slot);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, method_58350(stack));
                        method_5447(slot, directCopy(stack, insert));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                method_5431();
                                return List.of();
                            }
                        } else {
                            entry.setValue(remaining - insert);
                        }
                        dirty = true;
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            target.method_7939(count + insert);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    method_5431();
                                    return List.of();
                                }
                            } else {
                                entry.setValue(remaining - insert);
                            }
                            dirty = true;
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        if (dirty) {
            List<class_1799> result = new ArrayList<>(entries.size());
            for (Object2IntMap.Entry<class_1799> entry : entries) {
                class_1799 stack = entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                } else {
                    result.add(directCopy(stack, count));
                }
            }
            method_5431();
            return result;
        } else {
            return stacks;
        }
    }

    @Override
    default int insertExist(class_1799 stack) {
        return insertExist(stack, null);
    }

    @Override
    default int insertExist(class_1799 stack, int maxAmount) {
        return insertExist(stack, maxAmount, null);
    }

    @Override
    default int insertExist(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return insertExist(stack, maxAmount, side);
    }

    @Override
    default int insertExist(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        List<Integer> emptys = new ArrayList<>();
        for (int slot : create$getAvailableSlots(side)) {
            if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                class_1799 target = method_5438(slot);
                if (target.method_7960()) {
                    emptys.add(slot);
                } else if (matches(target, stack)) {
                    int maxCount = target.method_7914();
                    int count = target.method_7947();
                    if (count != maxCount) {
                        int insert = Math.min(remaining, maxCount - count);
                        target.method_7939(count + insert);
                        if (remaining == insert) {
                            method_5431();
                            return maxAmount;
                        }
                        remaining -= insert;
                    }
                }
            }
        }
        for (int slot : emptys) {
            int insert = Math.min(remaining, method_58350(stack));
            method_5447(slot, directCopy(stack, insert));
            if (remaining == insert) {
                method_5431();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        method_5431();
        return maxAmount - remaining;
    }

    @Override
    @NotNull
    default java.util.Iterator<class_1799> iterator() {
        return iterator(null);
    }

    @Override
    @NotNull
    default java.util.Iterator<class_1799> iterator(class_2350 side) {
        return new Iterator(this, side);
    }

    @Override
    default boolean preciseExtract(class_1799 stack) {
        return preciseExtract(stack, null);
    }

    @Override
    default boolean preciseExtract(class_1799 stack, class_2350 side) {
        if (stack.method_7960()) {
            return true;
        }
        int remaining = stack.method_7947();
        List<Runnable> changes = new ArrayList<>();
        for (int slot : create$getAvailableSlots(side)) {
            if (create$canExtract(slot, stack, side)) {
                class_1799 target = method_5438(slot);
                if (target.method_7960()) {
                    continue;
                }
                if (matches(target, stack)) {
                    int count = target.method_7947();
                    if (count > remaining) {
                        changes.forEach(Runnable::run);
                        target.method_7939(count - remaining);
                        method_5431();
                        return true;
                    }
                    if (count == remaining) {
                        changes.forEach(Runnable::run);
                        method_5447(slot, class_1799.field_8037);
                        method_5431();
                        return true;
                    }
                    changes.add(() -> method_5447(slot, class_1799.field_8037));
                    remaining -= count;
                }
            }
        }
        return false;
    }

    @Override
    default class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount) {
        return preciseExtract(predicate, maxAmount, null);
    }

    @Override
    default class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = create$getAvailableSlots(side);
        int size = slots.length;
        List<Integer> buffer = new ArrayList<>(size);
        for (int i = 0; i < size; i++) {
            int slot = slots[i];
            class_1799 findStack = method_5438(slot);
            if (findStack.method_7960()) {
                continue;
            }
            if (create$canExtract(slot, findStack, side) && predicate.test(findStack)) {
                int count = findStack.method_7947();
                if (count > maxAmount) {
                    findStack.method_7939(count - maxAmount);
                    method_5431();
                    return onExtract(directCopy(findStack, maxAmount));
                }
                if (count == maxAmount) {
                    method_5447(slot, class_1799.field_8037);
                    method_5431();
                    return onExtract(findStack);
                }
                buffer.add(slot);
                int remaining = maxAmount - count;
                for (i = i + 1; i < size; i++) {
                    slot = slots[i];
                    class_1799 stack = method_5438(slot);
                    if (stack.method_7960()) {
                        continue;
                    }
                    if (create$canExtract(slot, stack, side) && matches(stack, findStack)) {
                        count = stack.method_7947();
                        if (count < remaining) {
                            buffer.add(slot);
                            remaining -= count;
                            continue;
                        }
                        buffer.forEach(j -> method_5447(j, class_1799.field_8037));
                        if (count == remaining) {
                            method_5447(slot, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        method_5431();
                        findStack.method_7939(maxAmount);
                        return onExtract(findStack);
                    }
                }
            }
        }
        return class_1799.field_8037;
    }

    @Override
    default boolean preciseInsert(class_1799 stack) {
        return preciseInsert(stack, null);
    }

    @Override
    default boolean preciseInsert(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return true;
        }
        return preciseInsert(stack, maxAmount, side);
    }

    @Override
    default boolean preciseInsert(class_1799 stack, int maxAmount) {
        return preciseInsert(stack, maxAmount, null);
    }

    @Override
    default boolean preciseInsert(class_1799 stack, int maxAmount, class_2350 side) {
        List<Runnable> changes = new ArrayList<>();
        for (int slot : create$getAvailableSlots(side)) {
            if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                class_1799 target = method_5438(slot);
                if (target.method_7960()) {
                    int insert = Math.min(maxAmount, method_58350(stack));
                    if (maxAmount == insert) {
                        changes.forEach(Runnable::run);
                        method_5447(slot, directCopy(stack, insert));
                        method_5431();
                        return true;
                    }
                    changes.add(() -> method_5447(slot, directCopy(stack, insert)));
                    maxAmount -= insert;
                } else if (matches(target, stack)) {
                    int maxCount = target.method_7914();
                    int count = target.method_7947();
                    if (count != maxCount) {
                        int insert = Math.min(maxAmount, maxCount - count);
                        if (maxAmount == insert) {
                            changes.forEach(Runnable::run);
                            target.method_7939(count + insert);
                            method_5431();
                            return true;
                        }
                        changes.add(() -> target.method_7939(count + insert));
                        maxAmount -= insert;
                    }
                }
            }
        }
        return false;
    }

    @Override
    default boolean preciseInsert(List<class_1799> stacks) {
        return preciseInsert(stacks, null);
    }

    @Override
    default boolean preciseInsert(List<class_1799> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return preciseInsert(stacks.getFirst(), side);
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            return preciseInsert(entry.getKey(), entry.getIntValue(), side);
        }
        List<Runnable> changes = new ArrayList<>();
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 target = method_5438(slot);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$canInsert(slot, stack, side) && method_5437(slot, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, method_58350(stack));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                changes.forEach(Runnable::run);
                                method_5447(slot, directCopy(stack, insert));
                                method_5431();
                                return true;
                            }
                        } else {
                            changes.add(() -> method_5447(slot, directCopy(stack, insert)));
                            entry.setValue(remaining - insert);
                        }
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    changes.forEach(Runnable::run);
                                    target.method_7939(count + insert);
                                    method_5431();
                                    return true;
                                }
                            } else {
                                changes.add(() -> target.method_7939(count + insert));
                                entry.setValue(remaining - insert);
                            }
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        return false;
    }

    @Override
    default boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update) {
        return update(predicate, update, null);
    }

    @Override
    default boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update, class_2350 side) {
        for (int slot : create$getAvailableSlots(side)) {
            class_1799 stack = method_5438(slot);
            if (stack.method_7960()) {
                continue;
            }
            if (predicate.test(stack) && create$canExtract(slot, stack, side)) {
                class_1799 replace = update.apply(stack);
                if (replace != stack) {
                    method_5447(slot, replace);
                }
                method_5431();
                return true;
            }
        }
        return false;
    }

    class Iterator implements java.util.Iterator<class_1799> {
        private final BaseSidedInventory inventory;
        private final class_2350 side;
        private final int[] slots;
        private int index;
        private int current = -1;

        public Iterator(BaseSidedInventory inventory, class_2350 side) {
            this.inventory = inventory;
            this.side = side;
            this.slots = inventory.create$getAvailableSlots(side);
        }

        @Override
        public boolean hasNext() {
            if (current >= 0) {
                return true;
            }
            if (current == -2) {
                return false;
            }
            for (; index < slots.length; index++) {
                class_1799 stack = inventory.method_5438(slots[index]);
                if (inventory.create$canExtract(index, stack, side)) {
                    current = index;
                    index++;
                    return true;
                }
            }
            current = -2;
            return false;
        }

        @Override
        public class_1799 next() {
            if (hasNext()) {
                class_1799 result = inventory.method_5438(slots[current]);
                current = -1;
                return result;
            } else {
                throw new NoSuchElementException();
            }
        }
    }
}
