package com.zurrtum.create.infrastructure.packet.c2s;

import com.zurrtum.create.AllHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2792;
import net.minecraft.class_3244;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public record StationEditPacket(
    class_2338 pos, boolean dropSchedule, boolean assemblyMode, Boolean tryAssemble, DoorControl doorControl, String name
) implements class_2596<class_2792> {
    public static final class_9139<ByteBuf, StationEditPacket> CODEC = class_9139.method_58025(
        class_2338.field_48404,
        StationEditPacket::pos,
        class_9135.field_48547,
        StationEditPacket::dropSchedule,
        class_9135.field_48547,
        StationEditPacket::assemblyMode,
        CatnipStreamCodecBuilders.nullable(class_9135.field_48547),
        StationEditPacket::tryAssemble,
        CatnipStreamCodecBuilders.nullable(DoorControl.STREAM_CODEC),
        StationEditPacket::doorControl,
        CatnipStreamCodecBuilders.nullable(class_9135.method_56364(256)),
        StationEditPacket::name,
        StationEditPacket::new
    );

    public static StationEditPacket dropSchedule(class_2338 pos) {
        return new StationEditPacket(pos, true, false, false, null, null);
    }

    public static StationEditPacket tryAssemble(class_2338 pos) {
        return new StationEditPacket(pos, false, false, true, null, null);
    }

    public static StationEditPacket tryDisassemble(class_2338 pos) {
        return new StationEditPacket(pos, false, false, false, null, null);
    }

    public static StationEditPacket configure(class_2338 pos, boolean assemble, String name, DoorControl doorControl) {
        return new StationEditPacket(pos, false, assemble, null, doorControl, name);
    }

    @Override
    public void handle(class_2792 listener) {
        AllHandle.onStationEdit((class_3244) listener, this);
    }

    @Override
    public class_9145<StationEditPacket> method_65080() {
        return AllPackets.CONFIGURE_STATION;
    }
}
