package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.infrastructure.items.BaseInventory;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public record BlueprintPreviewPacket(
    List<class_1799> available, List<class_1799> missing, class_1799 result
) implements class_2596<class_2602> {
    public static final class_9139<class_9129, BlueprintPreviewPacket> CODEC = class_9139.method_56436(
        class_1799.field_48349.method_56433(class_9135.method_56363()),
        BlueprintPreviewPacket::available,
        class_1799.field_48349.method_56433(class_9135.method_56363()),
        BlueprintPreviewPacket::missing,
        class_1799.field_49268,
        BlueprintPreviewPacket::result,
        BlueprintPreviewPacket::new
    );
    public static final BlueprintPreviewPacket EMPTY = new BlueprintPreviewPacket(List.of(), List.of(), class_1799.field_8037);

    public static Object2IntLinkedOpenCustomHashMap<class_1799> createMap() {
        return new Object2IntLinkedOpenCustomHashMap<>(BaseInventory.ITEM_STACK_HASH_STRATEGY);
    }

    public static Object2IntLinkedOpenCustomHashMap<class_1799> createMap(Object2IntLinkedOpenCustomHashMap<class_1799> source) {
        return new Object2IntLinkedOpenCustomHashMap<>(source, BaseInventory.ITEM_STACK_HASH_STRATEGY);
    }

    public BlueprintPreviewPacket(
        Object2IntLinkedOpenCustomHashMap<class_1799> available,
        Object2IntLinkedOpenCustomHashMap<class_1799> missing,
        class_1799 result
    ) {
        this(toList(available), toList(missing), result);
    }

    public BlueprintPreviewPacket(Object2IntLinkedOpenCustomHashMap<class_1799> available, List<class_1799> missing, class_1799 result) {
        this(toList(available), missing, result);
    }

    private static List<class_1799> toList(Object2IntLinkedOpenCustomHashMap<class_1799> map) {
        ObjectBidirectionalIterator<Object2IntMap.Entry<class_1799>> iterator = map.object2IntEntrySet().fastIterator();
        List<class_1799> result = new ArrayList<>();
        while (iterator.hasNext()) {
            Object2IntMap.Entry<class_1799> entry = iterator.next();
            class_1799 stack = entry.getKey();
            int maxCount = stack.method_7914();
            int count = entry.getIntValue();
            while (count > maxCount) {
                result.add(stack.method_46651(maxCount));
                count -= maxCount;
            }
            result.add(stack.method_46651(count));
        }
        return result;
    }

    @Override
    public void handle(class_2602 listener) {
        AllClientHandle.INSTANCE.onBlueprintPreview(this);
    }

    @Override
    public class_9145<BlueprintPreviewPacket> method_65080() {
        return AllPackets.BLUEPRINT_PREVIEW;
    }
}