package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.infrastructure.debugInfo.DebugInformation;
import com.zurrtum.create.infrastructure.debugInfo.element.DebugInfoSection;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public record ServerDebugInfoPacket(String serverInfo) implements class_2596<class_2602> {
    public static final class_9139<ByteBuf, ServerDebugInfoPacket> CODEC = class_9135.field_48554.method_56432(
        ServerDebugInfoPacket::new,
        ServerDebugInfoPacket::serverInfo
    );

    public ServerDebugInfoPacket(class_1657 target) {
        this(printServerInfo(target));
    }

    private static String printServerInfo(class_1657 player) {
        List<DebugInfoSection> sections = DebugInformation.getServerInfo();
        StringBuilder output = new StringBuilder();
        printInfo("Server", player, sections, output);
        return output.toString();
    }

    public static void printInfo(String side, class_1657 player, List<DebugInfoSection> sections, StringBuilder output) {
        output.append("<details>");
        output.append('\n');
        output.append("<summary>").append(side).append(" Info").append("</summary>");
        output.append('\n').append('\n');
        output.append("```");
        output.append('\n');

        for (int i = 0; i < sections.size(); i++) {
            if (i != 0) {
                output.append('\n');
            }
            sections.get(i).print(player, line -> output.append(line).append('\n'));
        }

        output.append("```");
        output.append('\n').append('\n');
        output.append("</details>");
        output.append('\n');
    }

    @Override
    public void handle(class_2602 listener) {
        AllClientHandle.INSTANCE.onServerDebugInfo(this);
    }

    @Override
    public class_9145<ServerDebugInfoPacket> method_65080() {
        return AllPackets.SERVER_DEBUG_INFO;
    }
}
