package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.graph.*;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import java.util.*;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2602;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public class TrackGraphSyncPacket extends TrackGraphPacket {
    public static final class_9139<class_2540, TrackGraphSyncPacket> CODEC = class_9139.method_56438(
        TrackGraphSyncPacket::write,
        TrackGraphSyncPacket::new
    );

    @Override
    public void handle(class_2602 listener) {
        AllClientHandle.INSTANCE.onTrackGraphSync(this);
    }

    @Override
    public class_9145<TrackGraphSyncPacket> method_65080() {
        return AllPackets.SYNC_RAIL_GRAPH;
    }

    public static final int NULL_GROUP = 0, PASSIVE_GROUP = 1, GROUP = 2;

    public Map<Integer, Pair<TrackNodeLocation, class_243>> addedNodes;
    public List<Pair<Pair<Couple<Integer>, TrackMaterial>, BezierConnection>> addedEdges;
    public List<Integer> removedNodes;
    public List<TrackEdgePoint> addedEdgePoints;
    public List<UUID> removedEdgePoints;
    public Map<Integer, Pair<Integer, UUID>> splitSubGraphs;
    public Map<Couple<Integer>, Pair<Integer, List<UUID>>> updatedEdgeData;
    public boolean fullWipe;

    public TrackGraphSyncPacket(UUID graphId, int netId) {
        this.graphId = graphId;
        this.netId = netId;
        addedNodes = new HashMap<>();
        addedEdges = new ArrayList<>();
        removedNodes = new ArrayList<>();
        addedEdgePoints = new ArrayList<>();
        removedEdgePoints = new ArrayList<>();
        updatedEdgeData = new HashMap<>();
        splitSubGraphs = new HashMap<>();
        packetDeletesGraph = false;
    }

    public TrackGraphSyncPacket(class_2540 buffer) {
        int size;

        graphId = buffer.method_10790();
        netId = buffer.readInt();
        packetDeletesGraph = buffer.readBoolean();
        fullWipe = buffer.readBoolean();

        if (packetDeletesGraph)
            return;

        DimensionPalette dimensions = DimensionPalette.PACKET_CODEC.decode(buffer);

        addedNodes = new HashMap<>();
        addedEdges = new ArrayList<>();
        addedEdgePoints = new ArrayList<>();
        removedEdgePoints = new ArrayList<>();
        removedNodes = new ArrayList<>();
        splitSubGraphs = new HashMap<>();
        updatedEdgeData = new HashMap<>();

        size = buffer.method_10816();
        for (int i = 0; i < size; i++)
            removedNodes.add(buffer.method_10816());

        size = buffer.method_10816();
        for (int i = 0; i < size; i++)
            addedNodes.put(buffer.method_10816(), Pair.of(TrackNodeLocation.receive(buffer, dimensions), VecHelper.read(buffer)));

        size = buffer.method_10816();
        for (int i = 0; i < size; i++)
            addedEdges.add(Pair.of(
                Pair.of(Couple.create(buffer::method_10816), TrackMaterial.PACKET_CODEC.decode(buffer)),
                buffer.readBoolean() ? new BezierConnection(buffer) : null
            ));

        size = buffer.method_10816();
        for (int i = 0; i < size; i++)
            addedEdgePoints.add(EdgePointType.read(buffer, dimensions));

        size = buffer.method_10816();
        for (int i = 0; i < size; i++)
            removedEdgePoints.add(buffer.method_10790());

        size = buffer.method_10816();
        for (int i = 0; i < size; i++) {
            ArrayList<UUID> list = new ArrayList<>();
            Couple<Integer> key = Couple.create(buffer::readInt);
            Pair<Integer, List<UUID>> entry = Pair.of(buffer.method_10816(), list);
            int size2 = buffer.method_10816();
            for (int j = 0; j < size2; j++)
                list.add(buffer.method_10790());
            updatedEdgeData.put(key, entry);
        }

        size = buffer.method_10816();
        for (int i = 0; i < size; i++)
            splitSubGraphs.put(buffer.method_10816(), Pair.of(buffer.readInt(), buffer.method_10790()));
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(graphId);
        buffer.method_53002(netId);
        buffer.method_52964(packetDeletesGraph);
        buffer.method_52964(fullWipe);

        if (packetDeletesGraph)
            return;

        // Populate and send palette ahead of time
        DimensionPalette dimensions = new DimensionPalette();
        addedNodes.forEach((node, loc) -> dimensions.encode(loc.getFirst().dimension));
        addedEdgePoints.forEach(ep -> ep.edgeLocation.forEach(loc -> dimensions.encode(loc.dimension)));
        DimensionPalette.PACKET_CODEC.encode(buffer, dimensions);

        buffer.method_10804(removedNodes.size());
        removedNodes.forEach(buffer::method_10804);

        buffer.method_10804(addedNodes.size());
        addedNodes.forEach((node, loc) -> {
            buffer.method_10804(node);
            loc.getFirst().send(buffer, dimensions);
            class_243.field_52694.encode(buffer, loc.getSecond());
        });

        buffer.method_10804(addedEdges.size());
        addedEdges.forEach(pair -> {
            pair.getFirst().getFirst().forEach(buffer::method_10804);
            TrackMaterial.PACKET_CODEC.encode(buffer, pair.getFirst().getSecond());
            BezierConnection turn = pair.getSecond();
            buffer.method_52964(turn != null);
            if (turn != null)
                turn.write(buffer);
        });

        buffer.method_10804(addedEdgePoints.size());
        addedEdgePoints.forEach(ep -> ep.write(buffer, dimensions));

        buffer.method_10804(removedEdgePoints.size());
        removedEdgePoints.forEach(buffer::method_10797);

        buffer.method_10804(updatedEdgeData.size());
        for (Map.Entry<Couple<Integer>, Pair<Integer, List<UUID>>> entry : updatedEdgeData.entrySet()) {
            entry.getKey().forEach(buffer::method_53002);
            Pair<Integer, List<UUID>> pair = entry.getValue();
            buffer.method_10804(pair.getFirst());
            List<UUID> list = pair.getSecond();
            buffer.method_10804(list.size());
            list.forEach(buffer::method_10797);
        }

        buffer.method_10804(splitSubGraphs.size());
        splitSubGraphs.forEach((node, p) -> {
            buffer.method_10804(node);
            buffer.method_53002(p.getFirst());
            buffer.method_10797(p.getSecond());
        });
    }

    public void syncEdgeData(TrackNode node1, TrackNode node2, TrackEdge edge) {
        Couple<Integer> key = Couple.create(node1.getNetId(), node2.getNetId());
        List<UUID> list = new ArrayList<>();
        EdgeData edgeData = edge.getEdgeData();
        int groupType = edgeData.hasSignalBoundaries() ? NULL_GROUP : EdgeData.passiveGroup.equals(edgeData.getSingleSignalGroup()) ? PASSIVE_GROUP : GROUP;
        if (groupType == GROUP)
            list.add(edgeData.getSingleSignalGroup());
        for (TrackEdgePoint point : edgeData.getPoints())
            list.add(point.getId());
        updatedEdgeData.put(key, Pair.of(groupType, list));
    }
}
