package com.zurrtum.create.infrastructure.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllParticleTypes;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record CubeParticleData(float red, float green, float blue, float scale, int avgAge, boolean hot) implements class_2394 {

    public static final MapCodec<CubeParticleData> CODEC = RecordCodecBuilder.mapCodec(i -> i.group(
        Codec.FLOAT.fieldOf("r").forGetter(CubeParticleData::red),
        Codec.FLOAT.fieldOf("g").forGetter(CubeParticleData::green),
        Codec.FLOAT.fieldOf("b").forGetter(CubeParticleData::blue),
        Codec.FLOAT.fieldOf("scale").forGetter(CubeParticleData::scale),
        Codec.INT.fieldOf("avg_age").forGetter(CubeParticleData::avgAge),
        Codec.BOOL.fieldOf("hot").forGetter(CubeParticleData::hot)
    ).apply(i, CubeParticleData::new));

    public static final class_9139<class_9129, CubeParticleData> STREAM_CODEC = class_9139.method_58025(
        class_9135.field_48552,
        CubeParticleData::red,
        class_9135.field_48552,
        CubeParticleData::green,
        class_9135.field_48552,
        CubeParticleData::blue,
        class_9135.field_48552,
        CubeParticleData::scale,
        class_9135.field_49675,
        CubeParticleData::avgAge,
        class_9135.field_48547,
        CubeParticleData::hot,
        CubeParticleData::new
    );

    @Override
    public class_2396<CubeParticleData> method_10295() {
        return AllParticleTypes.CUBE;
    }
}
