package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryPlacementContext;
import com.zurrtum.create.foundation.item.ItemPlacementSoundContext;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1747.class)
public class BlockItemMixin {
    @WrapOperation(method = "useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", at = @At(value = "NEW", target = "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/item/context/BlockPlaceContext;"))
    private class_1750 replaceContext(class_1838 context, Operation<class_1750> original) {
        if (context instanceof SymmetryPlacementContext placementContext) {
            return placementContext;
        }
        return original.call(context);
    }

    @WrapOperation(method = "place(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/InteractionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;getSoundType()Lnet/minecraft/world/level/block/SoundType;"))
    private class_2498 checkSound(
        class_2680 instance,
        Operation<class_2498> original,
        @Local(argsOnly = true) class_1750 ctx,
        @Share("group") LocalRef<ItemPlacementSoundContext> group
    ) {
        if (ctx instanceof ItemPlacementSoundContext context) {
            group.set(context);
            return null;
        }
        return original.call(instance);
    }

    @WrapOperation(method = "place(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/InteractionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/BlockItem;getPlaceSound(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/sounds/SoundEvent;"))
    private class_3414 getGroup(
        class_1747 instance,
        class_2680 state,
        Operation<class_3414> original,
        @Share("group") LocalRef<ItemPlacementSoundContext> group
    ) {
        ItemPlacementSoundContext context = group.get();
        if (context != null) {
            class_3414 sound = context.getSound();
            if (sound != null) {
                return sound;
            }
        }
        return original.call(instance, state);
    }

    @WrapOperation(method = "place(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/InteractionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/SoundType;getVolume()F"))
    private float getVolume(class_2498 instance, Operation<Float> original, @Share("group") LocalRef<ItemPlacementSoundContext> group) {
        if (instance == null) {
            return group.get().getVolume();
        }
        return original.call(instance);
    }

    @WrapOperation(method = "place(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/InteractionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/SoundType;getPitch()F"))
    private float getPitch(class_2498 instance, Operation<Float> original, @Share("group") LocalRef<ItemPlacementSoundContext> group) {
        if (instance == null) {
            return group.get().getPitch();
        }
        return original.call(instance);
    }
}
