package com.zurrtum.create.mixin;

import com.zurrtum.create.infrastructure.items.BaseInventory;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1263.class)
public interface ContainerMixin extends BaseInventory {
    @Shadow
    void setItem(int slot, class_1799 stack);

    @Shadow
    int getContainerSize();

    @Shadow
    int getMaxStackSize(class_1799 stack);

    @Shadow
    class_1799 getItem(int slot);

    @Shadow
    boolean canPlaceItem(int slot, class_1799 stack);

    @Shadow
    void setChanged();

    @Override
    default void create$setStack(int slot, class_1799 stack) {
        setItem(slot, stack);
    }

    @Override
    default int create$size() {
        return getContainerSize();
    }

    @Override
    default int create$getMaxCount(class_1799 stack) {
        return getMaxStackSize(stack);
    }

    @Override
    default class_1799 create$getStack(int slot) {
        return getItem(slot);
    }

    @Override
    default boolean create$isValid(int slot, class_1799 stack) {
        return canPlaceItem(slot, stack);
    }

    @Override
    default void create$markDirty() {
        setChanged();
    }
}
