package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2313;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_9904;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_2313.class)
public class DetectorRailBlockMixin {
    @WrapOperation(method = "updatePowerToConnected(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;neighborChanged(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/level/redstone/Orientation;Z)V"))
    private void updateNeighbor(
        class_1937 world,
        class_2680 state,
        class_2338 neighborPos,
        class_2248 sourceBlock,
        class_9904 orientation,
        boolean notify,
        Operation<Void> original,
        @Local(argsOnly = true) class_2338 pos
    ) {
        if (state.method_26204() instanceof NeighborUpdateListeningBlock block) {
            block.neighborUpdate(state, world, neighborPos, sourceBlock, pos, notify);
        }
        original.call(world, state, neighborPos, sourceBlock, orientation, notify);
    }
}
