package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.foundation.block.ResistanceControlBlock;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_5362;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_5362.class)
public class ExplosionDamageCalculatorMixin {
    @WrapOperation(method = "getBlockExplosionResistance(Lnet/minecraft/world/level/Explosion;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/FluidState;)Ljava/util/Optional;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/Block;getExplosionResistance()F"))
    private float getBlastResistance(
        class_2248 block,
        Operation<Float> original,
        @Local(argsOnly = true) class_1922 world,
        @Local(argsOnly = true) class_2338 pos
    ) {
        if (block instanceof ResistanceControlBlock controlBlock) {
            return controlBlock.getResistance(world, pos);
        }
        return original.call(block);
    }
}
