package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SyncedBlockEntity;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.item.ItemHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3218;

@Mixin(class_2818.class)
public abstract class LevelChunkMixin {
    @Shadow
    public abstract class_1937 getLevel();

    @Shadow
    public abstract Map<class_2338, class_2586> getBlockEntities();

    @Inject(method = "setBlockEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/chunk/LevelChunk;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"))
    private void setBlockEntity(class_2586 blockEntity, CallbackInfo info, @Local class_2338 pos) {
        if (getLevel() instanceof class_3218) {
            ItemHelper.invalidateInventoryCache(pos);
            FluidHelper.invalidateInventoryCache(pos);
        }
    }

    @WrapOperation(method = "getBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/LevelChunk$EntityCreationType;)Lnet/minecraft/world/level/block/entity/BlockEntity;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/entity/BlockEntity;isRemoved()Z"))
    private boolean onRemoveBlockEntity(class_2586 instance, Operation<Boolean> original, @Local(argsOnly = true) class_2338 pos) {
        if (original.call(instance)) {
            ItemHelper.invalidateInventoryCache(pos);
            FluidHelper.invalidateInventoryCache(pos);
            return true;
        }
        return false;
    }

    @Inject(method = "removeBlockEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/chunk/LevelChunk;removeGameEventListener(Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/server/level/ServerLevel;)V"))
    private void onRemoveBlockEntity(class_2338 pos, CallbackInfo ci) {
        ItemHelper.invalidateInventoryCache(pos);
        FluidHelper.invalidateInventoryCache(pos);
    }

    @WrapOperation(method = "method_31716(Lnet/minecraft/util/ProblemReporter$ScopedCollector;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/nbt/CompoundTag;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/entity/BlockEntity;loadWithComponents(Lnet/minecraft/world/level/storage/ValueInput;)V"))
    private void handleUpdateTag(class_2586 blockEntity, class_11368 view, Operation<Void> original) {
        if (blockEntity instanceof SyncedBlockEntity syncedBlockEntity) {
            syncedBlockEntity.handleUpdateTag(view);
        } else {
            original.call(blockEntity, view);
        }
    }

    @Inject(method = "clearAllBlockEntities()V", at = @At("HEAD"))
    private void clear(CallbackInfo ci) {
        getBlockEntities().values().forEach(blockEntity -> {
            if (blockEntity instanceof SmartBlockEntity sbe) {
                sbe.onChunkUnloaded();
            }
        });
    }
}
