package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.content.trains.entity.CarriageEntityHandler;
import net.minecraft.class_1297;
import net.minecraft.class_5568;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets = "net.minecraft.world.level.entity.PersistentEntitySectionManager$Callback")
public class PersistentEntitySectionManagerCallbackMixin<T extends class_5568> {
    @Shadow
    @Final
    private T entity;

    @Shadow
    private long currentSectionKey;

    @Inject(method = "onMove()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/entity/PersistentEntitySectionManager$Callback;updateStatus(Lnet/minecraft/world/level/entity/Visibility;Lnet/minecraft/world/level/entity/Visibility;)V"))
    private void onEnteringSection(CallbackInfo ci, @Local long oldPos) {
        if (entity instanceof class_1297 realEntity) {
            CarriageEntityHandler.onEntityEnterSection(realEntity, oldPos, currentSectionKey);
        }
    }
}
