package com.zurrtum.create.mixin;

import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.equipment.armor.CardboardArmorHandler;
import com.zurrtum.create.content.equipment.armor.DivingBootsItem;
import com.zurrtum.create.content.equipment.toolbox.ToolboxHandler;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7159;
import net.minecraft.class_7165;
import net.minecraft.class_9904;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3218.class)
public abstract class ServerLevelMixin extends class_1937 {
    protected ServerLevelMixin(
        class_5269 properties,
        class_5321<class_1937> registryRef,
        class_5455 registryManager,
        class_6880<class_2874> dimensionEntry,
        boolean isClient,
        boolean debugWorld,
        long seed,
        int maxChainedNeighborUpdates
    ) {
        super(properties, registryRef, registryManager, dimensionEntry, isClient, debugWorld, seed, maxChainedNeighborUpdates);
    }

    @Inject(method = "tickNonPassenger(Lnet/minecraft/world/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;tick()V"))
    private void tickEntity(class_1297 entity, CallbackInfo ci) {
        CapabilityMinecartController.entityTick(entity);
        DivingBootsItem.accelerateDescentUnderwater(entity);
        CardboardArmorHandler.mobsMayLoseTargetWhenItIsWearingCardboard(entity);
        ToolboxHandler.entityTick(entity, (class_3218) (Object) this);
    }

    @Unique
    private void updateNeighbor(class_2338 pos, class_2350 direction, class_2248 sourceBlock) {
        class_2338 target = pos.method_10093(direction);
        class_2680 state = method_8320(target);
        if (state.method_26204() instanceof NeighborUpdateListeningBlock block) {
            block.neighborUpdate(state, (class_3218) (Object) this, target, sourceBlock, pos, false);
        }
    }

    @Inject(method = "updateNeighborsAt(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/level/redstone/Orientation;)V", at = @At("HEAD"))
    private void updateNeighborsAlways(class_2338 pos, class_2248 sourceBlock, class_9904 orientation, CallbackInfo ci) {
        if (field_38226 instanceof class_7159) {
            return;
        }
        for (class_2350 direction : class_7165.field_37839) {
            updateNeighbor(pos, direction, sourceBlock);
        }
    }

    @Inject(method = "updateNeighborsAtExceptFromFacing(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/redstone/Orientation;)V", at = @At("HEAD"))
    private void updateNeighborsExcept(class_2338 pos, class_2248 sourceBlock, class_2350 except, class_9904 orientation, CallbackInfo ci) {
        if (field_38226 instanceof class_7159) {
            return;
        }
        for (class_2350 direction : class_7165.field_37839) {
            if (direction == except) {
                continue;
            }
            updateNeighbor(pos, direction, sourceBlock);
        }
    }
}
