package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.foundation.blockEntity.EntityControlStructureProcessor;
import com.zurrtum.create.foundation.blockEntity.StructureEntityInfoIterator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

@Mixin(class_3499.class)
public class StructureTemplateMixin {
    @Unique
    private static final ThreadLocal<List<EntityControlStructureProcessor>> list = new ThreadLocal<>();

    @Inject(method = "placeInWorld(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Lnet/minecraft/util/RandomSource;I)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;placeEntities(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Mirror;Lnet/minecraft/world/level/block/Rotation;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;ZLnet/minecraft/util/ProblemReporter;)V"))
    private void setProcessors(
        class_5425 world,
        class_2338 pos,
        class_2338 pivot,
        class_3492 placementData,
        class_5819 random,
        int flags,
        CallbackInfoReturnable<Boolean> cir
    ) {
        if (world instanceof class_1937) {
            List<EntityControlStructureProcessor> controls = new ArrayList<>();
            for (class_3491 processor : placementData.method_16182()) {
                if (processor instanceof EntityControlStructureProcessor control) {
                    controls.add(control);
                }
            }
            if (!controls.isEmpty()) {
                list.set(controls);
            }
        }
    }

    @WrapOperation(method = "placeEntities(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Mirror;Lnet/minecraft/world/level/block/Rotation;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;ZLnet/minecraft/util/ProblemReporter;)V", at = @At(value = "INVOKE", target = "Ljava/util/List;iterator()Ljava/util/Iterator;"))
    private Iterator<class_3499.class_3502> getIterator(
        List<class_3499.class_3502> instance,
        Operation<Iterator<class_3499.class_3502>> original,
        @Local(argsOnly = true) class_5425 access
    ) {
        Iterator<class_3499.class_3502> iterator = original.call(instance);
        List<EntityControlStructureProcessor> controls = list.get();
        if (controls == null) {
            return iterator;
        }
        return new StructureEntityInfoIterator((class_1937) access, controls, iterator);
    }

    @Inject(method = "placeEntities(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Mirror;Lnet/minecraft/world/level/block/Rotation;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;ZLnet/minecraft/util/ProblemReporter;)V", at = @At("TAIL"))
    private void clearProcessors(CallbackInfo ci) {
        list.remove();
    }
}
