package com.zurrtum.create;

import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayBoardTarget;
import com.zurrtum.create.content.redstone.displayLink.target.LecternDisplayTarget;
import com.zurrtum.create.content.redstone.displayLink.target.NixieTubeDisplayTarget;
import com.zurrtum.create.content.redstone.displayLink.target.SignDisplayTarget;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;

import static com.zurrtum.create.Create.MOD_ID;

public class AllDisplayTargets {
    public static final SignDisplayTarget SIGN = register("sign", SignDisplayTarget::new);
    public static final LecternDisplayTarget LECTERN = register("lectern", LecternDisplayTarget::new);
    public static final DisplayBoardTarget DISPLAY_BOARD = register("display_board", DisplayBoardTarget::new);
    public static final NixieTubeDisplayTarget NIXIE_TUBE = register("nixie_tube", NixieTubeDisplayTarget::new);

    private static <T extends DisplayTarget> T register(String id, Supplier<T> factory) {
        return class_2378.method_10230(CreateRegistries.DISPLAY_TARGET, class_2960.method_60655(MOD_ID, id), factory.get());
    }

    public static void register(DisplayTarget display, class_2248... blocks) {
        for (class_2248 block : blocks) {
            DisplayTarget.BY_BLOCK.register(block, display);
        }
    }

    public static void register(DisplayTarget display, class_2591<?> type) {
        DisplayTarget.BY_BLOCK_ENTITY.register(type, display);
    }

    public static void register() {
        register(SIGN, class_2591.field_11911);
        register(LECTERN, class_2591.field_16412);
        register(DISPLAY_BOARD, AllBlocks.DISPLAY_BOARD);
        register(NIXIE_TUBE, AllBlockEntityTypes.NIXIE_TUBE);
    }
}
