package com.zurrtum.create;

import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.trains.schedule.condition.*;
import com.zurrtum.create.content.trains.schedule.destination.*;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;

import static com.zurrtum.create.Create.MOD_ID;

public class AllSchedules {
    public static List<Pair<class_2960, Function<class_2960, ? extends ScheduleInstruction>>> INSTRUCTION_TYPES = new ArrayList<>();
    public static List<Pair<class_2960, Function<class_2960, ? extends ScheduleWaitCondition>>> CONDITION_TYPES = new ArrayList<>();
    public static final class_2960 DESTINATION = registerInstruction("destination", DestinationInstruction::new);
    public static final class_2960 PACKAGE_DELIVERY = registerInstruction("package_delivery", DeliverPackagesInstruction::new);
    public static final class_2960 PACKAGE_RETRIEVAL = registerInstruction("package_retrieval", FetchPackagesInstruction::new);
    public static final class_2960 RENAME = registerInstruction("rename", ChangeTitleInstruction::new);
    public static final class_2960 THROTTLE = registerInstruction("throttle", ChangeThrottleInstruction::new);
    public static final class_2960 DELAY = registerCondition("delay", ScheduledDelay::new);
    public static final class_2960 TIME_OF_DAY = registerCondition("time_of_day", TimeOfDayCondition::new);
    public static final class_2960 FLUID_THRESHOLD = registerCondition("fluid_threshold", FluidThresholdCondition::new);
    public static final class_2960 ITEM_THRESHOLD = registerCondition("item_threshold", ItemThresholdCondition::new);
    public static final class_2960 REDSTONE_LINK = registerCondition("redstone_link", RedstoneLinkCondition::new);
    public static final class_2960 PLAYER_COUNT = registerCondition("player_count", PlayerPassengerCondition::new);
    public static final class_2960 IDLE = registerCondition("idle", IdleCargoCondition::new);
    public static final class_2960 UNLOADED = registerCondition("unloaded", StationUnloadedCondition::new);
    public static final class_2960 POWERED = registerCondition("powered", StationPoweredCondition::new);

    public static ScheduleInstruction createScheduleInstruction(class_2960 location) {
        for (Pair<class_2960, Function<class_2960, ? extends ScheduleInstruction>> type : INSTRUCTION_TYPES) {
            if (type.getFirst().equals(location)) {
                return type.getSecond().apply(location);
            }
        }
        return null;
    }

    public static ScheduleWaitCondition createScheduleWaitCondition(class_2960 location) {
        for (Pair<class_2960, Function<class_2960, ? extends ScheduleWaitCondition>> type : CONDITION_TYPES) {
            if (type.getFirst().equals(location)) {
                return type.getSecond().apply(location);
            }
        }
        return null;
    }

    private static class_2960 registerInstruction(String name, Function<class_2960, ? extends ScheduleInstruction> factory) {
        class_2960 id = class_2960.method_60655(MOD_ID, name);
        INSTRUCTION_TYPES.add(Pair.of(id, factory));
        return id;
    }

    private static class_2960 registerCondition(String name, Function<class_2960, ? extends ScheduleWaitCondition> factory) {
        class_2960 id = class_2960.method_60655(MOD_ID, name);
        CONDITION_TYPES.add(Pair.of(id, factory));
        return id;
    }

    public static void register() {
    }
}
