package com.zurrtum.create.client;

import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.content.equipment.potatoCannon.PotatoProjectileTransform;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes.Billboard;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes.StuckToEntity;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes.TowardMotion;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes.Tumble;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class AllPotatoProjectileTransforms {
    public static final Map<Class<? extends PotatoProjectileRenderMode>, PotatoProjectileTransform<?>> ALL = new IdentityHashMap<>();

    @SuppressWarnings("unchecked")
    public static <T extends PotatoProjectileRenderMode> PotatoProjectileTransform<T> get(T renderMode) {
        return (PotatoProjectileTransform<T>) ALL.get(renderMode.getClass());
    }

    private static <T extends PotatoProjectileRenderMode> void register(Class<T> renderMode, PotatoProjectileTransform<T> transform) {
        ALL.put(renderMode, transform);
    }

    @SuppressWarnings("SuspiciousNameCombination")
    public static void register() {
        register(
            Billboard.class, (mode, ms, state) -> {
                class_243 p1 = state.camera.method_5836(state.pt);
                class_243 diff = state.box.method_1005().method_1020(p1);

                TransformStack.of(ms).rotateYDegrees(AngleHelper.deg(class_3532.method_15349(diff.field_1352, diff.field_1350)) + 180)
                    .rotateXDegrees(AngleHelper.deg(class_3532.method_15349(diff.field_1351, class_3532.method_15355((float) (diff.field_1352 * diff.field_1352 + diff.field_1350 * diff.field_1350)))));
            }
        );
        register(
            Tumble.class, (mode, ms, state) -> {
                get(Billboard.INSTANCE).transform(Billboard.INSTANCE, ms, state);
                TransformStack.of(ms).rotateZDegrees(state.field_53328 * 2 * (state.hash % 16)).rotateXDegrees(state.field_53328 * (state.hash % 32));
            }
        );
        register(
            TowardMotion.class, (mode, ms, state) -> {
                class_243 diff = state.velocity;
                TransformStack.of(ms).rotateYDegrees(AngleHelper.deg(class_3532.method_15349(diff.field_1352, diff.field_1350)))
                    .rotateXDegrees(270 + AngleHelper.deg(class_3532.method_15349(diff.field_1351, -class_3532.method_15355((float) (diff.field_1352 * diff.field_1352 + diff.field_1350 * diff.field_1350)))));
                TransformStack.of(ms).rotateYDegrees(state.field_53328 * 20 * mode.spin() + (state.hash % 360)).rotateZDegrees(-mode.spriteAngleOffset());
            }
        );
        register(
            StuckToEntity.class, (mode, ms, state) -> {
                class_243 offset = mode.offset();
                TransformStack.of(ms).rotateYDegrees(AngleHelper.deg(class_3532.method_15349(offset.field_1352, offset.field_1350)));
            }
        );
    }
}
