package com.zurrtum.create.client.catnip.math;

import net.minecraft.class_11902;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VecHelper {
    // https://forums.minecraftforge.net/topic/88562-116solved-3d-to-2d-conversion/?do=findComment&comment=413573
    // slightly modified
    public static class_243 projectToPlayerView(class_243 target, float partialTicks) {
        /*
         * The (centered) location on the screen of the given 3d point in the world.
         * Result is (dist right of center screen, dist up from center screen, if < 0,
         * then in front of view plane)
         */
        class_4184 ari = class_310.method_1551().field_1773.method_19418();
        class_243 camera_pos = ari.method_19326();
        Quaternionf camera_rotation_conj = new Quaternionf(ari.method_23767());
        camera_rotation_conj.conjugate();

        Vector3f result3f = new Vector3f((float) (camera_pos.field_1352 - target.field_1352), (float) (camera_pos.field_1351 - target.field_1351), (float) (camera_pos.field_1350 - target.field_1350));
        result3f.rotate(camera_rotation_conj);

        // ----- compensate for view bobbing (if active) -----
        // the following code adapted from GameRenderer::applyBobbing (to invert it)
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.method_42448().method_41753()) {
            class_1297 renderViewEntity = mc.method_1560();
            if (renderViewEntity instanceof class_746 playerEntity) {
                class_11902 clientPlayerLikeState = playerEntity.method_74192();
                float f = clientPlayerLikeState.method_74205(partialTicks);
                float g = clientPlayerLikeState.method_74204(partialTicks);
                Quaternionf q2 = class_7833.field_40714.rotationDegrees(Math.abs(class_3532.method_15362(f * (float) Math.PI - 0.2F) * g) * 5.0F);
                q2.conjugate();
                result3f.rotate(q2);

                Quaternionf q1 = class_7833.field_40718.rotationDegrees(class_3532.method_15374(f * (float) Math.PI) * g * 3.0F);
                q1.conjugate();
                result3f.rotate(q1);

                Vector3f bob_translation = new Vector3f(
                    class_3532.method_15374(f * (float) Math.PI) * g * 0.5F,
                    -Math.abs(class_3532.method_15362(f * (float) Math.PI) * g),
                    0.0f
                );
                bob_translation.set(bob_translation.x(), -bob_translation.y(), bob_translation.z());// this is weird but hey, if it works
                result3f.add(bob_translation);
            }
        }

        // ----- adjust for fov -----
        float fov = mc.field_1773.method_3196(ari, partialTicks, true);

        float half_height = (float) mc.method_22683().method_4502() / 2;
        float scale_factor = half_height / (result3f.z() * (float) Math.tan(Math.toRadians(fov / 2)));
        return new class_243(-result3f.x() * scale_factor, result3f.y() * scale_factor, result3f.z());
    }
}
