package com.zurrtum.create.client.catnip.outliner;

import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Vector3d;
import org.joml.Vector4f;

public class LineOutline extends Outline {

    protected final Vector3d start = new Vector3d(0, 0, 0);
    protected final Vector3d end = new Vector3d(0, 0, 0);

    public LineOutline set(Vector3d start, Vector3d end) {
        this.start.set(start.x, start.y, start.z);
        this.end.set(end.x, end.y, end.z);
        return this;
    }

    public LineOutline set(class_243 start, class_243 end) {
        this.start.set(start.field_1352, start.field_1351, start.field_1350);
        this.end.set(end.field_1352, end.field_1351, end.field_1350);
        return this;
    }

    @Override
    public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt) {
        float width = params.getLineWidth();
        if (width == 0)
            return;

        class_4588 consumer = buffer.method_73477(PonderRenderTypes.outlineSolid());
        params.loadColor(colorTemp);
        Vector4f color = colorTemp;
        int lightmap = params.lightmap;
        boolean disableLineNormals = params.disableLineNormals;
        renderInner(ms, consumer, camera, pt, width, color, lightmap, disableLineNormals);
    }

    protected void renderInner(
        class_4587 ms,
        class_4588 consumer,
        class_243 camera,
        float pt,
        float width,
        Vector4f color,
        int lightmap,
        boolean disableNormals
    ) {
        bufferCuboidLine(ms, consumer, camera, start, end, width, color, lightmap, disableNormals);
    }

    public static class EndChasingLineOutline extends LineOutline {
        private float progress = 0;
        private float prevProgress = 0;
        private boolean lockStart;

        private final Vector3d startTemp = new Vector3d(0, 0, 0);

        public EndChasingLineOutline(boolean lockStart) {
            this.lockStart = lockStart;
        }

        public EndChasingLineOutline setProgress(float progress) {
            prevProgress = this.progress;
            this.progress = progress;
            return this;
        }

        @Override
        protected void renderInner(
            class_4587 ms,
            class_4588 consumer,
            class_243 camera,
            float pt,
            float width,
            Vector4f color,
            int lightmap,
            boolean disableNormals
        ) {
            float distanceToTarget = class_3532.method_16439(pt, prevProgress, progress);

            Vector3d end;
            if (lockStart) {
                end = this.start;
            } else {
                end = this.end;
                distanceToTarget = 1 - distanceToTarget;
            }

            Vector3d start = this.startTemp;
            double x = (this.start.x - end.x) * distanceToTarget + end.x;
            double y = (this.start.y - end.y) * distanceToTarget + end.y;
            double z = (this.start.z - end.z) * distanceToTarget + end.z;
            start.set((float) x, (float) y, (float) z);
            bufferCuboidLine(ms, consumer, camera, start, end, width, color, lightmap, disableNormals);
        }
    }

}
