package com.zurrtum.create.client.catnip.render;

import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_2960;

public class SpriteShiftEntry {
    @Nullable
    protected StitchedSprite original;
    @Nullable
    protected StitchedSprite target;

    public void set(class_2960 originalLocation, class_2960 targetLocation) {
        original = new StitchedSprite(originalLocation);
        target = new StitchedSprite(targetLocation);
    }

    public class_2960 getOriginalResourceLocation() {
        Objects.requireNonNull(original);
        return original.getLocation();
    }

    public class_2960 getTargetResourceLocation() {
        Objects.requireNonNull(target);
        return target.getLocation();
    }

    public class_1058 getOriginal() {
        Objects.requireNonNull(original);
        return original.get();
    }

    public class_1058 getTarget() {
        Objects.requireNonNull(target);
        return target.get();
    }

    public float getTargetU(float localU) {
        return getTarget().method_4580(getUnInterpolatedU(getOriginal(), localU));
    }

    public float getTargetV(float localV) {
        return getTarget().method_4570(getUnInterpolatedV(getOriginal(), localV));
    }

    public static float getUnInterpolatedU(class_1058 sprite, float u) {
        float f = sprite.method_4577() - sprite.method_4594();
        return (u - sprite.method_4594()) / f;
    }

    public static float getUnInterpolatedV(class_1058 sprite, float v) {
        float f = sprite.method_4575() - sprite.method_4593();
        return (v - sprite.method_4593()) / f;
    }
}
