package com.zurrtum.create.client.compat.computercraft;

import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.Mods;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class ComputerScreen extends AbstractSimiScreen {

    private final AllGuiTextures background = AllGuiTextures.COMPUTER;

    private final Supplier<class_2561> displayTitle;
    private final AdditionalRenderer additionalRenderer;
    private final class_437 previousScreen;
    private final Supplier<Boolean> hasAttachedComputer;

    private ElementWidget computerWidget;
    private IconButton confirmButton;

    public ComputerScreen(class_2561 title, @Nullable AdditionalRenderer additionalRenderer, class_437 previousScreen, Supplier<Boolean> hasAttachedComputer) {
        this(title, () -> title, additionalRenderer, previousScreen, hasAttachedComputer);
    }

    public ComputerScreen(
        class_2561 title,
        Supplier<class_2561> displayTitle,
        @Nullable AdditionalRenderer additionalRenderer,
        class_437 previousScreen,
        Supplier<Boolean> hasAttachedComputer
    ) {
        super(title);
        this.displayTitle = displayTitle;
        this.additionalRenderer = additionalRenderer;
        this.previousScreen = previousScreen;
        this.hasAttachedComputer = hasAttachedComputer;
    }

    @Override
    public void method_25393() {
        if (!hasAttachedComputer.get())
            field_22787.method_1507(previousScreen);

        super.method_25393();
    }

    @Override
    protected void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight());
        super.method_25426();

        int x = guiLeft;
        int y = guiTop;

        if (Mods.COMPUTERCRAFT.isLoaded()) {
            computerWidget = new ElementWidget(x + 33, y + 38).showingElement(GuiGameElement.of(Mods.COMPUTERCRAFT.getItem("computer_advanced")));
            computerWidget.getToolTip().add(CreateLang.translate("gui.attached_computer.hint").component());
            method_37063(computerWidget);
        }

        confirmButton = new IconButton(x + background.getWidth() - 33, y + background.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(this::method_25419);
        method_37063(confirmButton);

        if (additionalRenderer != null) {
            additionalRenderer.addAdditional(this, x, y, background);
        }
    }

    @Override
    public void method_25419() {
        super.method_25419();
        previousScreen.method_25419();
        if (computerWidget != null) {
            computerWidget.getRenderElement().clear();
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;

        background.render(graphics, x, y);

        graphics.method_51439(
            field_22793,
            displayTitle.get(),
            Math.round(x + background.getWidth() / 2.0F - field_22793.method_27525(displayTitle.get()) / 2.0F),
            y + 4,
            0xFF442000,
            false
        );
        graphics.method_51440(
            field_22793,
            CreateLang.translate("gui.attached_computer.controlled").component(),
            x + 55,
            y + 32,
            111,
            0xFF7A7A7A,
            false
        );

        if (additionalRenderer != null)
            additionalRenderer.updateAdditional(partialTicks);
    }

    public interface AdditionalRenderer {
        void addAdditional(class_437 screen, int x, int y, AllGuiTextures background);

        default void updateAdditional(float partialTicks) {
        }
    }
}
