package com.zurrtum.create.client.compat.jei;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.equipment.blueprint.BlueprintMenu;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.InTagAttribute;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.ItemAttributeEntry;
import com.zurrtum.create.infrastructure.packet.c2s.BlueprintAssignCompleteRecipePacket;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9288;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BlueprintTransferHandler implements IRecipeTransferHandler<BlueprintMenu, class_8786<class_3955>> {
    @Override
    public Class<? extends BlueprintMenu> getContainerClass() {
        return BlueprintMenu.class;
    }

    @Override
    public Optional<class_3917<BlueprintMenu>> getMenuType() {
        return Optional.empty();
    }

    @Override
    public IRecipeType<class_8786<class_3955>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Override
    public @Nullable IRecipeTransferError transferRecipe(
        BlueprintMenu menu,
        class_8786<class_3955> craftingRecipe,
        IRecipeSlotsView recipeSlots,
        class_1657 player,
        boolean maxTransfer,
        boolean doTransfer
    ) {
        if (!doTransfer)
            return null;

        List<IRecipeSlotView> inputViews = new ArrayList<>();
        List<IRecipeSlotView> outputViews = new ArrayList<>();
        for (IRecipeSlotView view : recipeSlots.getSlotViews()) {
            RecipeIngredientRole role = view.getRole();
            if (role == RecipeIngredientRole.INPUT) {
                inputViews.add(view);
            } else if (role == RecipeIngredientRole.OUTPUT) {
                outputViews.add(view);
            }
        }
        class_1799 output = null;
        for (IRecipeSlotView view : outputViews) {
            Optional<class_1799> stack = view.getDisplayedItemStack();
            if (stack.isPresent()) {
                output = stack.get();
                break;
            }
        }
        if (output == null) {
            return new RecipeTransferErrorMissingSlots(class_2561.method_43471("jei.tooltip.error.recipe.transfer.missing"), outputViews);
        }
        List<class_6862<class_1792>> cache = new ArrayList<>();
        List<class_1799> input = new ArrayList<>();
        for (IRecipeSlotView view : inputViews) {
            List<class_1799> ingredient = view.getItemStacks().toList();
            int size = ingredient.size();
            if (size == 0) {
                input.add(class_1799.field_8037);
                continue;
            }
            if (size == 1) {
                input.add(ingredient.getFirst());
                continue;
            }
            class_6862<class_1792> tag = findTag(ingredient, cache);
            if (tag != null) {
                class_1799 filterItem = AllItems.ATTRIBUTE_FILTER.method_7854();
                filterItem.method_57379(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, AttributeFilterWhitelistMode.WHITELIST_DISJ);
                filterItem.method_57379(
                    AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES,
                    List.of(new ItemAttributeEntry(new InTagAttribute(tag), false))
                );
                input.add(filterItem);
                continue;
            }
            class_1799 filterItem = AllItems.FILTER.method_7854();
            filterItem.method_57379(AllDataComponents.FILTER_ITEMS, class_9288.method_57493(ingredient));
            input.add(filterItem);
        }
        BlueprintAssignCompleteRecipePacket packet = new BlueprintAssignCompleteRecipePacket(input, output);
        ((class_746) player).field_3944.method_52787(packet);
        return null;
    }

    @Nullable
    public static class_6862<class_1792> findTag(List<class_1799> ingredient, List<class_6862<class_1792>> cache) {
        List<class_6880.class_6883<class_1792>> list = getEntries(ingredient);
        for (class_6862<class_1792> tag : cache) {
            if (matchTag(list, tag)) {
                return tag;
            }
        }
        int size = list.size();
        return class_7923.field_41178.method_40272().filter(set -> set.method_40247() == size).map(class_6885.class_6888::method_40251).filter(t -> matchTag(list, t))
            .findFirst().map(tag -> {
                cache.add(tag);
                return tag;
            }).orElse(null);
    }

    @SuppressWarnings("deprecation")
    public static List<class_6880.class_6883<class_1792>> getEntries(List<class_1799> ingredient) {
        List<class_6880.class_6883<class_1792>> list = new ArrayList<>(ingredient.size());
        for (class_1799 stack : ingredient) {
            list.add(stack.method_7909().method_40131());
        }
        return list;
    }

    public static boolean matchTag(List<class_6880.class_6883<class_1792>> list, class_6862<class_1792> tag) {
        for (class_6880.class_6883<class_1792> entry : list) {
            if (entry.method_40220(tag)) {
                continue;
            }
            return false;
        }
        return true;
    }
}
