package com.zurrtum.create.client.compat.jei;

import com.zurrtum.create.client.content.logistics.filter.AttributeFilterScreen;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.foundation.gui.menu.GhostItemMenu;
import com.zurrtum.create.infrastructure.packet.c2s.GhostItemSubmitPacket;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;

import java.util.LinkedList;
import java.util.List;

public class GhostIngredientHandler<T extends AbstractSimiContainerScreen<? extends GhostItemMenu<?>>> implements IGhostIngredientHandler<T> {
    @Override
    @NotNull
    public <I> List<Target<I>> getTargetsTyped(T gui, ITypedIngredient<I> ingredient, boolean doStart) {
        List<Target<I>> targets = new LinkedList<>();

        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            if (gui instanceof AttributeFilterScreen) {
                if (gui.method_17577().field_7761.get(36).method_7682())
                    targets.add(new GhostTarget<I, T>(gui, 0, true));
            } else {
                for (int i = 36; i < gui.method_17577().field_7761.size(); i++) {
                    if (gui.method_17577().field_7761.get(i).method_7682())
                        targets.add(new GhostTarget<>(gui, i - 36, false));
                }
            }
        }

        return targets;
    }

    @Override
    public void onComplete() {
    }

    @Override
    public boolean shouldHighlightTargets() {
        // TODO change to false and highlight the slots ourself in some better way
        return true;
    }

    private static class GhostTarget<I, T extends AbstractSimiContainerScreen<? extends GhostItemMenu<?>>> implements Target<I> {

        private final class_768 area;
        private final T gui;
        private final int slotIndex;
        private final boolean isAttributeFilter;

        public GhostTarget(T gui, int slotIndex, boolean isAttributeFilter) {
            this.gui = gui;
            this.slotIndex = slotIndex;
            this.isAttributeFilter = isAttributeFilter;
            class_1735 slot = gui.method_17577().field_7761.get(slotIndex + 36);
            this.area = new class_768(gui.getGuiLeft() + slot.field_7873, gui.getGuiTop() + slot.field_7872, 16, 16);
        }

        @Override
        @NotNull
        public class_768 getArea() {
            return area;
        }

        @Override
        public void accept(I ingredient) {
            class_1799 stack = ((class_1799) ingredient).method_7972();
            stack.method_7939(1);
            gui.method_17577().ghostInventory.method_5447(slotIndex, stack);

            if (isAttributeFilter)
                return;

            // sync new filter contents with server
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.field_3944.method_52787(new GhostItemSubmitPacket(stack, slotIndex));
            }
        }
    }
}