package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.PressBasinRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.recipe.*;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class AutoCompactingCategory extends CreateCategory<class_8786<class_3955>> {
    public static List<class_8786<class_3955>> getRecipes(class_10289 preparedRecipes) {
        List<class_8786<class_3955>> recipes = new ArrayList<>();
        for (class_8786<class_3955> entry : preparedRecipes.method_64698(class_3956.field_17545)) {
            class_3955 recipe = entry.comp_1933();
            if (!MechanicalPressBlockEntity.canCompress(recipe) || AllRecipeTypes.shouldIgnoreInAutomation(entry)) {
                continue;
            }
            if (recipe instanceof class_1867 || recipe instanceof class_1869) {
                recipes.add(entry);
            }
        }
        return recipes;
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<class_3955>> getRecipeType() {
        return JeiClientPlugin.AUTOMATIC_PACKING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.automatic_packing");
    }

    @Override
    public IDrawable getIcon() {
        return new TwoIconRenderer(AllItems.MECHANICAL_PRESS, class_1802.field_8465);
    }

    @Override
    public int getHeight() {
        return 85;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<class_3955> entry, IFocusGroup focuses) {
        class_3955 recipe = entry.comp_1933();
        class_1799 result;
        List<class_1856> ingredients;
        if (recipe instanceof class_1869 shapedRecipe) {
            result = shapedRecipe.field_9053;
            ingredients = shapedRecipe.method_61693().stream().filter(Optional::isPresent).map(Optional::get).toList();
        } else if (recipe instanceof class_1867 shapelessRecipe) {
            result = shapelessRecipe.field_9050;
            ingredients = shapelessRecipe.field_9047;
        } else {
            return;
        }
        for (int i = 0, size = ingredients.size(), rows = size == 4 ? 2 : 3; i < size; i++) {
            builder.addInputSlot((rows == 2 ? 27 : 18) + (i % rows) * 19, 51 - (i / rows) * 19).setBackground(SLOT, -1, -1).add(ingredients.get(i));
        }
        builder.addOutputSlot(142, 51).setBackground(SLOT, -1, -1).add(result);
    }

    @Override
    public void draw(class_8786<class_3955> entry, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, 32);
        AllGuiTextures.JEI_SHADOW.render(graphics, 81, 68);
        graphics.field_59826.method_70922(new PressBasinRenderState(new Matrix3x2f(graphics.method_51448()), 91, -5));
    }
}
