package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.display.BlockCuttingDisplay;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.SawRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_6885;
import net.minecraft.class_8786;
import net.minecraft.recipe.*;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BlockCuttingCategory extends CreateCategory<BlockCuttingDisplay> {
    public static List<BlockCuttingDisplay> getRecipes(class_10289 preparedRecipes) {
        Object2ObjectMap<class_1856, Pair<class_2960, List<class_1799>>> map = new Object2ObjectOpenCustomHashMap<>(new Hash.Strategy<>() {
            public boolean equals(class_1856 ingredient, class_1856 other) {
                return Objects.equals(ingredient, other);
            }

            public int hashCode(class_1856 ingredient) {
                if (ingredient.field_9019 instanceof class_6885.class_6886<class_1792> direct) {
                    return direct.hashCode();
                }
                if (ingredient.field_9019 instanceof class_6885.class_6888<class_1792> named) {
                    return named.method_40251().comp_327().hashCode();
                }
                return ingredient.hashCode();
            }
        });
        for (class_8786<class_3975> entry : preparedRecipes.method_64698(class_3956.field_17641)) {
            if (AllRecipeTypes.shouldIgnoreInAutomation(entry)) {
                continue;
            }
            class_3975 recipe = entry.comp_1933();
            map.computeIfAbsent(recipe.method_64720(), i -> Pair.of(entry.comp_1932().method_29177(), new ArrayList<>())).getSecond().add(recipe.method_64721());
        }
        List<BlockCuttingDisplay> recipes = new ArrayList<>();
        for (Object2ObjectMap.Entry<class_1856, Pair<class_2960, List<class_1799>>> entry : map.object2ObjectEntrySet()) {
            Pair<class_2960, List<class_1799>> pair = entry.getValue();
            List<class_1799> outputs = pair.getSecond();
            int size = outputs.size();
            if (size <= 15) {
                recipes.add(new BlockCuttingDisplay(pair.getFirst(), entry.getKey(), outputs.stream().map(List::of).toList()));
                continue;
            }
            List<List<class_1799>> list = new ArrayList<>(15);
            for (int i = 0; i < 15; i++) {
                List<class_1799> stacks = new ArrayList<>(2);
                stacks.add(outputs.get(i));
                list.add(stacks);
            }
            for (int i = 15; i < size; i++) {
                list.get(i % 15).add(outputs.get(i));
            }
            recipes.add(new BlockCuttingDisplay(pair.getFirst(), entry.getKey(), list));
        }
        return recipes;
    }

    @Override
    public class_2960 getRegistryName(BlockCuttingDisplay display) {
        return display.id();
    }

    @Override
    @NotNull
    public IRecipeType<BlockCuttingDisplay> getRecipeType() {
        return JeiClientPlugin.BLOCK_CUTTING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.block_cutting");
    }

    @Override
    public IDrawable getIcon() {
        return new TwoIconRenderer(AllItems.MECHANICAL_SAW, class_1802.field_8481);
    }

    @Override
    public int getHeight() {
        return 70;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, BlockCuttingDisplay display, IFocusGroup focuses) {
        builder.addInputSlot(5, 5).setBackground(SLOT, -1, -1).add(display.input());
        List<List<class_1799>> outputs = display.outputs();
        for (int i = 0, left = 78, top = 48, size = outputs.size(); i < size; i++) {
            builder.addOutputSlot(left + (i % 5) * 19, top + (i / 5) * -19).setBackground(SLOT, -1, -1).addItemStacks(outputs.get(i));
        }
    }

    @Override
    public void draw(BlockCuttingDisplay recipe, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 31, 6);
        AllGuiTextures.JEI_SHADOW.render(graphics, 16, 50);
        graphics.field_59826.method_70922(new SawRenderState(new Matrix3x2f(graphics.method_51448()), 25, 26));
    }
}
