package com.zurrtum.create.client.compat.rei;

import com.zurrtum.create.client.content.equipment.blueprint.BlueprintScreen;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelSetItemScreen;
import com.zurrtum.create.client.content.logistics.filter.AbstractFilterScreen;
import com.zurrtum.create.client.content.logistics.filter.AttributeFilterScreen;
import com.zurrtum.create.client.content.logistics.redstoneRequester.RedstoneRequesterScreen;
import com.zurrtum.create.client.content.redstone.link.controller.LinkedControllerScreen;
import com.zurrtum.create.client.content.trains.schedule.ScheduleScreen;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.foundation.gui.menu.GhostItemMenu;
import com.zurrtum.create.infrastructure.packet.c2s.GhostItemSubmitPacket;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class GhostIngredientHandler<T extends GhostItemMenu<?>> implements DraggableStackVisitor<AbstractSimiContainerScreen<T>> {
    @Override
    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<AbstractSimiContainerScreen<T>> context, DraggableStack stack) {
        Stream<BoundsProvider> bounds = getDraggableAcceptingBounds(context, stack);
        Point cursor = context.getCurrentPosition();
        if (cursor != null) {
            int x = cursor.getX();
            int y = cursor.getY();
            Optional<BoundsProvider> target = bounds.filter(b -> {
                class_238 box = b.bounds().method_1107();
                double minX = box.field_1323;
                double minY = box.field_1322;
                double maxX = box.field_1320;
                double maxY = box.field_1325;
                return x >= minX && x <= maxX && y >= minY && y <= maxY && b instanceof GhostTarget;
            }).findFirst();
            if (target.isPresent() && target.get() instanceof GhostTarget<?> ghost) {
                Object held = stack.getStack().getValue();
                if (held instanceof class_1799 item) {
                    ghost.accept(item);
                    return DraggedAcceptorResult.CONSUMED;
                }
            }
        }
        return DraggableStackVisitor.super.acceptDraggedStack(context, stack);
    }

    @Override
    public Stream<BoundsProvider> getDraggableAcceptingBounds(DraggingContext<AbstractSimiContainerScreen<T>> context, DraggableStack stack) {
        List<BoundsProvider> targets = new ArrayList<>();
        AbstractSimiContainerScreen<T> gui = context.getScreen();

        if (stack.getStack().getValue() instanceof class_1799) {
            if (gui instanceof AttributeFilterScreen) {
                if (gui.method_17577().field_7761.get(36).method_7682())
                    targets.add(new GhostTarget<>(gui, 0, true));
            } else {
                for (int i = 36; i < gui.method_17577().field_7761.size(); i++) {
                    if (gui.method_17577().field_7761.get(i).method_7682())
                        targets.add(new GhostTarget<>(gui, i - 36, false));
                }
            }
        }
        return targets.stream();
    }

    @Override
    public <R extends class_437> boolean isHandingScreen(R screen) {
        return screen instanceof AbstractFilterScreen || screen instanceof BlueprintScreen || screen instanceof LinkedControllerScreen || screen instanceof ScheduleScreen || screen instanceof RedstoneRequesterScreen || screen instanceof FactoryPanelSetItemScreen;
    }

    private static class GhostTarget<T extends GhostItemMenu<?>> implements BoundsProvider {

        private final class_265 area;
        private final AbstractSimiContainerScreen<T> gui;
        private final int slotIndex;
        private final boolean isAttributeFilter;

        public GhostTarget(AbstractSimiContainerScreen<T> gui, int slotIndex, boolean isAttributeFilter) {
            this.gui = gui;
            this.slotIndex = slotIndex;
            this.isAttributeFilter = isAttributeFilter;
            class_1735 slot = gui.method_17577().field_7761.get(slotIndex + 36);
            int minX = gui.getGuiLeft() + slot.field_7873;
            int minY = gui.getGuiTop() + slot.field_7872;
            this.area = class_259.method_31943(minX, minY, 0, minX + 16, minY + 16, 0.1);
        }

        public void accept(class_1799 ingredient) {
            class_1799 stack = ingredient.method_7972();
            stack.method_7939(1);
            gui.method_17577().ghostInventory.method_5447(slotIndex, stack);

            if (isAttributeFilter)
                return;

            // sync new filter contents with server
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.field_3944.method_52787(new GhostItemSubmitPacket(stack, slotIndex));
            }
        }

        @Override
        public class_265 bounds() {
            return area;
        }
    }
}
