package com.zurrtum.create.client.compat.rei.display;

import com.zurrtum.create.client.compat.rei.ReiClientPlugin;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;

public record MysteriousItemConversionDisplay(EntryIngredient input, EntryIngredient output) implements Display {
    public MysteriousItemConversionDisplay(class_1792 input, class_1792 output) {
        this(EntryIngredients.of(input), EntryIngredients.of(output));
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiClientPlugin.MYSTERY_CONVERSION;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return Optional.empty();
    }

    @Override
    public @Nullable DisplaySerializer<? extends Display> getSerializer() {
        return null;
    }
}
