package com.zurrtum.create.client.content.contraptions.actors.trainControls;

import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsMovementBehaviour.LeverAngles;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import org.joml.Matrix4f;

import java.util.Collection;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;

public class ControlsMovementRenderBehaviour implements MovementRenderBehaviour {
    @Override
    public MovementRenderState getRenderState(
        class_243 camera,
        class_327 textRenderer,
        MovementContext context,
        VirtualRenderWorld renderWorld,
        Matrix4f worldMatrix4f
    ) {
        if (!(context.temporaryData instanceof LeverAngles angles)) {
            return null;
        }
        AbstractContraptionEntity entity = context.contraption.entity;
        if (!(entity instanceof CarriageContraptionEntity cce)) {
            return null;
        }
        class_2680 blockState = context.state;
        class_2350 facing = blockState.method_11654(ControlsBlock.field_11177);
        if (ControlsHandler.getContraption() == entity && ControlsHandler.getControlsPos() != null && ControlsHandler.getControlsPos()
            .equals(context.localPos)) {
            Collection<Integer> pressed = ControlsHandler.currentlyPressed;
            angles.equipAnimation.chase(1, .2f, Chaser.EXP);
            angles.steering.chase((pressed.contains(3) ? 1 : 0) + (pressed.contains(2) ? -1 : 0), 0.2f, Chaser.EXP);
            class_2350 initialOrientation = cce.getInitialOrientation().method_10160();
            float f = cce.movingBackwards ^ !facing.equals(initialOrientation) ? -1 : 1;
            angles.speed.chase(Math.min(context.motion.method_1033(), 0.5f) * f, 0.2f, Chaser.EXP);
        } else {
            angles.equipAnimation.chase(0, .2f, Chaser.EXP);
            angles.steering.chase(0, 0, Chaser.EXP);
            angles.speed.chase(0, 0, Chaser.EXP);
        }
        float pt = AnimationTickHolder.getPartialTicks(context.world);
        ControlsMovementRenderState state = new ControlsMovementRenderState(context.localPos);
        state.layer = class_1921.method_23579();
        state.cover = CachedBuffers.partial(AllPartialModels.TRAIN_CONTROLS_COVER, blockState);
        state.lever = CachedBuffers.partial(AllPartialModels.TRAIN_CONTROLS_LEVER, blockState);
        state.yRot = class_3532.field_29847 * (180 + AngleHelper.horizontalAngle(facing));
        state.light = class_761.method_23794(renderWorld, context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        float equipAnimation = angles.equipAnimation.getValue(pt);
        float firstLever = angles.speed.getValue(pt);
        float secondLever = angles.steering.getValue(pt);
        state.offsetY = class_3532.method_16439(equipAnimation * equipAnimation, -0.15f, 0.05f);
        state.firstAngle = class_3532.field_29847 * (class_3532.method_15363(firstLever * 70 - 25, -45, 45) - 45);
        state.secondAngle = class_3532.field_29847 * (class_3532.method_15363(secondLever * 15, -45, 45) - 45);
        state.xRot = class_3532.field_29847 * 45;
        return state;
    }

    public static class ControlsMovementRenderState extends MovementRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer cover;
        public SuperByteBuffer lever;
        public float yRot;
        public int light;
        public class_1937 world;
        public Matrix4f worldMatrix4f;
        public float offsetY;
        public float firstAngle;
        public float secondAngle;
        public float xRot;

        public ControlsMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, layer, this);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            cover.center().rotateY(yRot).uncenter().light(light).useLevelLight(world, worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            lever.center().rotateY(yRot).translate(0, 0.25f, 0.25f).rotateX(firstAngle).translate(0, offsetY, 0).rotateX(xRot).uncenter()
                .translate(0, -0.375f, -0.1875f).light(light).useLevelLight(world, worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            lever.center().rotateY(yRot).translate(0, 0.25f, 0.25f).rotateX(secondAngle).translate(0, offsetY, 0).rotateX(xRot).uncenter()
                .translate(0.375f, -0.375f, -0.1875f).light(light).useLevelLight(world, worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
