package com.zurrtum.create.client.content.contraptions.bearing;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.contraptions.bearing.IBearingBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_11683;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class BearingRenderer<T extends KineticBlockEntity & IBearingBlockEntity> extends KineticBlockEntityRenderer<T, BearingRenderer.BearingRenderState> {
    public BearingRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public BearingRenderState createRenderState() {
        return new BearingRenderState();
    }

    @Override
    public void updateRenderState(
        T be,
        BearingRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        PartialModel top = be.isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        state.top = CachedBuffers.partial(top, state.blockState);
        state.topAngle = (float) (be.getInterpolatedAngle(tickProgress - 1) / 180 * Math.PI);
        if (state.axis != class_2351.field_11052) {
            state.upAngle = AngleHelper.rad(AngleHelper.horizontalAngle(state.facing.method_10153()));
        } else {
            state.upAngle = -1;
        }
        state.eastAngle = AngleHelper.rad(-90 - AngleHelper.verticalAngle(state.facing));
    }

    @Override
    public void updateBaseRenderState(
        T be,
        BearingRenderState state,
        class_1937 world,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateBaseRenderState(be, state, world, crumblingOverlay);
        state.facing = state.blockState.get(class_2741.field_12525);
    }

    @Override
    protected class_1921 getRenderType(T be, class_2680 state) {
        return class_1921.method_23577();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be, BearingRenderState state) {
        return CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, state.facing.method_10153());
    }

    public static class BearingRenderState extends KineticRenderState {
        public class_2350 facing;
        public SuperByteBuffer top;
        public float topAngle;
        public float upAngle;
        public float eastAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            top.light(lightmapCoordinates);
            top.rotateCentered(topAngle, direction);
            top.color(color);
            if (upAngle != -1) {
                top.rotateCentered(upAngle, class_2350.field_11036);
            }
            top.rotateCentered(eastAngle, class_2350.field_11034);
            top.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
