package com.zurrtum.create.client.content.contraptions.gantry;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_11683;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class GantryCarriageRenderer extends KineticBlockEntityRenderer<GantryCarriageBlockEntity, GantryCarriageRenderer.GantryCarriageRenderState> {
    public GantryCarriageRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public GantryCarriageRenderState createRenderState() {
        return new GantryCarriageRenderState();
    }

    @Override
    public void updateRenderState(
        GantryCarriageBlockEntity be,
        GantryCarriageRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        class_2680 blockState = be.method_11010();
        class_2350 facing = blockState.method_11654(GantryCarriageBlock.FACING);
        Boolean alongFirst = blockState.method_11654(GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        class_2351 rotationAxis = state.axis;
        class_2338 visualPos = facing.method_10171() == class_2352.field_11056 ? be.method_11016() : be.method_11016().method_10093(facing.method_10153());
        float angleForBE = getAngleForBE(be, visualPos, rotationAxis);
        class_2351 gantryAxis = class_2351.field_11048;
        for (class_2351 axis : Iterate.axes) {
            if (axis != rotationAxis && axis != facing.method_10166()) {
                gantryAxis = axis;
            }
        }
        if (gantryAxis == class_2351.field_11048 && facing == class_2350.field_11036) {
            angleForBE *= -1;
        }
        if (gantryAxis == class_2351.field_11052 && (facing == class_2350.field_11043 || facing == class_2350.field_11034)) {
            angleForBE *= -1;
        }
        state.cogs = CachedBuffers.partial(AllPartialModels.GANTRY_COGS, blockState);
        state.yRot = class_3532.field_29847 * AngleHelper.horizontalAngle(facing);
        state.xRot = class_3532.field_29847 * (facing == class_2350.field_11036 ? 0 : facing == class_2350.field_11033 ? 180 : 90);
        state.yRot2 = class_3532.field_29847 * (alongFirst ^ facing.method_10166() == class_2351.field_11048 ? 0 : 90);
        state.xRot2 = class_3532.field_29847 * -angleForBE;
    }

    @Override
    protected class_1921 getRenderType(GantryCarriageBlockEntity be, class_2680 state) {
        return class_1921.method_23577();
    }

    public static float getAngleForBE(KineticBlockEntity be, final class_2338 pos, class_2351 axis) {
        float time = AnimationTickHolder.getRenderTime(be.method_10997());
        float offset = getRotationOffsetForPosition(be, pos, axis);
        return (time * be.getSpeed() * 3f / 20 + offset) % 360;
    }

    @Override
    protected class_2680 getRenderedBlockState(GantryCarriageBlockEntity be) {
        return shaft(getRotationAxisOf(be));
    }

    public static class GantryCarriageRenderState extends KineticRenderState {
        public SuperByteBuffer cogs;
        public float yRot;
        public float xRot;
        public float yRot2;
        public float xRot2;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            cogs.center().rotateY(yRot).rotateX(xRot).rotateY(yRot2);
            if (xRot2 != 0) {
                cogs.translate(0, -0.5625f, 0).rotateX(xRot2).translate(0, 0.5625f, 0);
            }
            cogs.uncenter().light(lightmapCoordinates).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
