package com.zurrtum.create.client.content.contraptions.pulley;

import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_11683;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPulleyRenderer<T extends KineticBlockEntity> extends KineticBlockEntityRenderer<T, AbstractPulleyRenderer.PulleyRenderState> {
    private final PartialModel halfRope;
    private final PartialModel halfMagnet;

    public AbstractPulleyRenderer(class_5614.class_5615 context, PartialModel halfRope, PartialModel halfMagnet) {
        super(context);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    @Override
    public PulleyRenderState createRenderState() {
        return new PulleyRenderState();
    }

    @Override
    public void updateRenderState(
        T be,
        PulleyRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        float offset = getOffset(be, tickProgress);
        boolean running = isRunning(be);
        state.coil = getRotatedCoil(be);
        state.coilShift = getCoilShift();
        state.coilScroll = getCoilVScroll(state.coilShift, offset, 1);
        class_1937 world = be.method_10997();
        class_2680 blockState = be.method_11010();
        if (running || offset == 0) {
            state.magnet = offset > .25f ? renderMagnet(be) : CachedBuffers.partial(halfMagnet, blockState);
            state.magnetOffset = -offset;
            state.magnetLight = class_761.method_23794(world, state.pos.down((int) offset));
        }
        if (offset > .75f) {
            float f = offset % 1;
            if (f < .25f || f > .75f) {
                state.halfRope = CachedBuffers.partial(halfRope, blockState);
                float down = f > .75f ? f - 1 : f;
                state.halfRopeOffset = -down;
                state.halfRopeLight = class_761.method_23794(world, state.pos.down((int) down));
            }
        }
        if (!running || offset <= 1.25f) {
            return;
        }
        state.rope = renderRope(be);
        int size = (int) Math.ceil(offset - 1.25f);
        float[] offsets = new float[size];
        int[] lights = new int[size];
        for (int i = 0; i < size; i++) {
            float down = offset - i - 1;
            int light = class_761.method_23794(world, state.pos.down((int) down));
            offsets[i] = -down;
            lights[i] = light;
        }
        state.offsets = offsets;
        state.lights = lights;
    }

    @Override
    protected class_1921 getRenderType(T be, class_2680 state) {
        return class_1921.method_23577();
    }

    protected abstract class_2351 getShaftAxis(T be);

    protected abstract PartialModel getCoil();

    protected abstract SpriteShiftEntry getCoilShift();

    protected abstract SuperByteBuffer renderRope(T be);

    protected abstract SuperByteBuffer renderMagnet(T be);

    protected abstract float getOffset(T be, float partialTicks);

    protected abstract boolean isRunning(T be);

    @Override
    protected class_2680 getRenderedBlockState(T be) {
        return shaft(getShaftAxis(be));
    }

    protected SuperByteBuffer getRotatedCoil(T be) {
        class_2680 blockState = be.method_11010();
        return CachedBuffers.partialFacing(getCoil(), blockState, class_2350.method_10156(class_2352.field_11056, getShaftAxis(be)));
    }

    public static float getCoilVScroll(SpriteShiftEntry coilShift, float offset, float speedModifier) {
        if (offset == 0) {
            return 0;
        }
        float spriteSize = coilShift.getTarget().method_4575() - coilShift.getTarget().method_4593();
        offset *= speedModifier / 2;
        double coilScroll = -(offset + 3 / 16f) - Math.floor((offset + 3 / 16f) * -2) / 2;
        return (float) coilScroll * spriteSize;
    }

    @Override
    public int method_33893() {
        return AllConfigs.server().kinetics.maxRopeLength.get();
    }

    public static class PulleyRenderState extends KineticRenderState {
        public SuperByteBuffer coil;
        public SpriteShiftEntry coilShift;
        public float coilScroll;
        public SuperByteBuffer magnet;
        public float magnetOffset;
        public int magnetLight;
        public SuperByteBuffer halfRope;
        public float halfRopeOffset;
        public int halfRopeLight;
        public SuperByteBuffer rope;
        public float[] offsets;
        public int[] lights;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            if (coilScroll != 0) {
                coil.shiftUVScrolling(coilShift, coilScroll);
            }
            coil.light(lightmapCoordinates).renderInto(matricesEntry, vertexConsumer);
            if (magnet != null) {
                magnet.translate(0, magnetOffset, 0).light(magnetLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (halfRope != null) {
                halfRope.translate(0, halfRopeOffset, 0).light(halfRopeLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (rope != null) {
                for (int i = 0, size = offsets.length; i < size; i++) {
                    rope.translate(0, offsets[i], 0).light(lights[i]).renderInto(matricesEntry, vertexConsumer);
                }
            }
        }
    }
}
