package com.zurrtum.create.client.content.contraptions.pulley;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.content.processing.burner.ScrollInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.SmartRecycler;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.util.math.*;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

import java.util.function.Consumer;

public abstract class AbstractPulleyVisual<T extends KineticBlockEntity> extends ShaftVisual<T> implements SimpleDynamicVisual {
    private final ScrollInstance coil;
    private final TransformedInstance magnet;
    private final SmartRecycler<Boolean, TransformedInstance> rope;

    protected final class_2350 rotatingAbout;
    protected final class_7833 rotationAxis;

    private final LightCache lightCache = new LightCache();

    private float offset;

    public AbstractPulleyVisual(VisualizationContext dispatcher, T blockEntity, float partialTick) {
        super(dispatcher, blockEntity, partialTick);

        rotatingAbout = class_2350.method_10156(class_2350.class_2352.field_11056, rotationAxis());
        rotationAxis = class_7833.method_46356(rotatingAbout.method_23955());

        float blockStateAngle = AngleHelper.horizontalAngle(rotatingAbout);
        Quaternionfc rotation = new Quaternionf().rotationY(class_3532.field_29847 * blockStateAngle);

        coil = getCoilModel().createInstance().rotation(rotation).position(getVisualPosition()).setSpriteShift(getCoilAnimation());

        coil.setChanged();

        magnet = magnetInstancer().createInstance();

        rope = new SmartRecycler<>(b -> b ? getHalfRopeModel().createInstance() : getRopeModel().createInstance());

        updateOffset(partialTick);
        updateLight(partialTick);
        animate();
    }

    @Override
    public void setSectionCollector(SectionCollector sectionCollector) {
        super.setSectionCollector(sectionCollector);
        lightCache.updateSections();
    }

    protected abstract Instancer<TransformedInstance> getRopeModel();

    protected abstract Instancer<TransformedInstance> getMagnetModel();

    protected abstract Instancer<TransformedInstance> getHalfMagnetModel();

    protected abstract Instancer<ScrollInstance> getCoilModel();

    protected abstract Instancer<TransformedInstance> getHalfRopeModel();

    protected abstract float getOffset(float pt);

    protected abstract boolean isRunning();

    protected abstract SpriteShiftEntry getCoilAnimation();

    private Instancer<TransformedInstance> magnetInstancer() {
        return offset > .25f ? getMagnetModel() : getHalfMagnetModel();
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        updateOffset(ctx.partialTick());
        animate();
    }

    private void animate() {
        coil.offsetV = -offset;
        coil.setChanged();

        magnet.setVisible(isRunning() || offset == 0);

        magnetInstancer().stealInstance(magnet);

        magnet.setIdentityTransform().translate(getVisualPosition()).translate(0, -offset, 0)
            .light(lightCache.getPackedLight(Math.max(0, class_3532.method_15375(offset)))).setChanged();

        rope.resetCount();

        if (shouldRenderHalfRope()) {
            float f = offset % 1;
            float halfRopeNudge = f > .75f ? f - 1 : f;

            rope.get(true).setIdentityTransform().translate(getVisualPosition()).translate(0, -halfRopeNudge, 0).light(lightCache.getPackedLight(0))
                .setChanged();
        }

        if (isRunning()) {
            int neededRopeCount = getNeededRopeCount();

            for (int i = 0; i < neededRopeCount; i++) {

                rope.get(false).setIdentityTransform().translate(getVisualPosition()).translate(0, -offset + i + 1, 0)
                    .light(lightCache.getPackedLight(neededRopeCount - 1 - i)).setChanged();
            }
        }

        rope.discardExtra();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        relight(coil);

        lightCache.update();
    }

    private void updateOffset(float pt) {
        offset = getOffset(pt);
        lightCache.setSize(class_3532.method_15386(offset) + 2);
    }

    private int getNeededRopeCount() {
        return Math.max(0, class_3532.method_15386(offset - 1.25f));
    }

    private boolean shouldRenderHalfRope() {
        float f = offset % 1;
        return offset > .75f && (f < .25f || f > .75f);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(coil);
        consumer.accept(magnet);
    }

    @Override
    protected void _delete() {
        super._delete();
        coil.delete();
        magnet.delete();
        rope.delete();
    }

    private class LightCache {
        private final ByteList data = new ByteArrayList();
        private final LongSet sections = new LongOpenHashSet();
        private final class_2338.class_2339 mutablePos = new class_2338.class_2339();
        private int sectionCount;

        public void setSize(int size) {
            if (size != data.size()) {
                data.size(size);
                update();

                int sectionCount = MoreMath.ceilingDiv(size + 15 - pos.method_10264() + pos.method_10264() / 4 * 4, class_4076.field_33097);
                if (sectionCount != this.sectionCount) {
                    this.sectionCount = sectionCount;
                    sections.clear();
                    int sectionX = class_4076.method_18675(pos.method_10263());
                    int sectionY = class_4076.method_18675(pos.method_10264());
                    int sectionZ = class_4076.method_18675(pos.method_10260());
                    for (int i = 0; i < sectionCount; i++) {
                        sections.add(class_4076.method_18685(sectionX, sectionY - i, sectionZ));
                    }
                    // Will be null during initialization
                    if (lightSections != null) {
                        updateSections();
                    }
                }
            }
        }

        public void updateSections() {
            lightSections.sections(sections);
        }

        public void update() {
            mutablePos.method_10101(pos);

            for (int i = 0; i < data.size(); i++) {
                int blockLight = level.method_8314(class_1944.field_9282, mutablePos);
                int skyLight = level.method_8314(class_1944.field_9284, mutablePos);
                int light = ((skyLight & 0xF) << 4) | (blockLight & 0xF);
                data.set(i, (byte) light);
                mutablePos.method_10098(class_2350.field_11033);
            }
        }

        public int getPackedLight(int offset) {
            if (offset < 0 || offset >= data.size()) {
                return 0;
            }

            int light = Byte.toUnsignedInt(data.getByte(offset));
            int blockLight = light & 0xF;
            int skyLight = (light >>> 4) & 0xF;
            return class_765.method_23687(blockLight, skyLight);
        }
    }
}
