package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.AllContraptionTypeTags;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5617;


public class OrientedContraptionEntityRenderer<C extends OrientedContraptionEntity, S extends OrientedContraptionEntityRenderer.OrientedContraptionState> extends ContraptionEntityRenderer<C, S> {
    public OrientedContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    @SuppressWarnings("unchecked")
    public S method_55269() {
        return (S) new OrientedContraptionState();
    }

    @Override
    public boolean shouldRender(C entity, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        if (!super.shouldRender(entity, frustum, cameraX, cameraY, cameraZ))
            return false;
        return entity.method_5854() != null || !entity.getContraption().getType().is(AllContraptionTypeTags.REQUIRES_VEHICLE_FOR_RENDER);
    }

    @Override
    public void updateRenderState(C entity, S state, float tickProgress) {
        class_1297 ridingEntity = entity.method_5854();
        if (ridingEntity instanceof class_1688 cart) {
            state.offset = OrientedContraptionVisual.getCartOffset(tickProgress, cart);
        } else if (ridingEntity instanceof AbstractContraptionEntity be) {
            if (ridingEntity.method_5854() instanceof class_1688 cart) {
                state.offset = OrientedContraptionVisual.getCartOffset(tickProgress, cart);
            } else {
                state.offset = OrientedContraptionVisual.getContraptionOffset(entity, tickProgress, be);
            }
        }
        state.seed = entity.method_5628();
        boolean done = tickProgress == 1.0F;
        state.angleYaw = class_3532.field_29847 * (done ? -entity.yaw : -AngleHelper.angleLerp(tickProgress, entity.prevYaw, entity.yaw));
        state.anglePitch = class_3532.field_29847 * (done ? entity.pitch : AngleHelper.angleLerp(
            tickProgress,
            entity.prevPitch,
            entity.pitch
        ));
        state.angleInitialYaw = class_3532.field_29847 * entity.getInitialYaw();
        super.updateRenderState(entity, state, tickProgress);
    }

    @Override
    public void transform(OrientedContraptionState state, class_4587 matrixStack) {
        matrixStack.method_46416(-.5f, 0, -.5f);
        if (state.offset != null) {
            matrixStack.method_61958(state.offset);
        }
        TransformStack.of(matrixStack).nudge(state.seed).center().rotateY(state.angleYaw).rotateZ(state.anglePitch).rotateY(state.angleInitialYaw)
            .uncenter();
    }

    public static class OrientedContraptionState extends AbstractContraptionState {
        public float angleYaw;
        public float anglePitch;
        public float angleInitialYaw;
        int seed;
        class_243 offset;
    }
}
