package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_9878;
import net.minecraft.class_9879;
import net.minecraft.class_9883;

public class OrientedContraptionVisual<T extends OrientedContraptionEntity> extends ContraptionVisual<T> {
    public OrientedContraptionVisual(VisualizationContext ctx, T entity, float partialTick) {
        super(ctx, entity, partialTick);
    }

    @Override
    public void transform(class_4587 matrixStack, float partialTicks) {
        float angleInitialYaw = entity.getInitialYaw();
        float angleYaw = entity.getViewYRot(partialTicks);
        float anglePitch = entity.getViewXRot(partialTicks);

        matrixStack.method_46416(-.5f, 0, -.5f);

        class_1297 ridingEntity = entity.method_5854();
        if (ridingEntity instanceof class_1688 cart)
            repositionOnCart(matrixStack, partialTicks, cart);
        else if (ridingEntity instanceof AbstractContraptionEntity be) {
            if (ridingEntity.method_5854() instanceof class_1688 cart)
                repositionOnCart(matrixStack, partialTicks, cart);
            else
                repositionOnContraption(entity, matrixStack, partialTicks, be);
        }

        TransformStack.of(matrixStack).nudge(entity.method_5628()).center().rotateYDegrees(angleYaw).rotateZDegrees(anglePitch)
            .rotateYDegrees(angleInitialYaw).uncenter();
    }

    // Minecarts do not always render at their exact location, so the contraption
    // has to adjust aswell
    public static void repositionOnCart(class_4587 matrixStack, float partialTicks, class_1688 ridingEntity) {
        class_243 cartPos = getCartOffset(partialTicks, ridingEntity);

        if (cartPos == class_243.field_1353)
            return;

        matrixStack.method_22904(cartPos.field_1352, cartPos.field_1351, cartPos.field_1350);
    }

    public static class_243 getCartOffset(float partialTicks, class_1688 cart) {
        class_9878 behavior = cart.method_61569();
        if (behavior instanceof class_9883 controller) {
            double cartX = class_3532.method_16436(partialTicks, cart.field_6038, cart.method_23317());
            double cartY = class_3532.method_16436(partialTicks, cart.field_5971, cart.method_23318());
            double cartZ = class_3532.method_16436(partialTicks, cart.field_5989, cart.method_23321());

            class_243 cartPos = controller.method_61620(cartX, cartY, cartZ);
            if (cartPos != null) {
                class_243 cartPosFront = controller.method_61619(cartX, cartY, cartZ, 0.3F);
                class_243 cartPosBack = controller.method_61619(cartX, cartY, cartZ, -0.3F);
                if (cartPosFront == null)
                    cartPosFront = cartPos;
                if (cartPosBack == null)
                    cartPosBack = cartPos;

                cartX = cartPos.field_1352 - cartX;
                cartY = (cartPosFront.field_1351 + cartPosBack.field_1351) / 2.0D - cartY;
                cartZ = cartPos.field_1350 - cartZ;

                return new class_243(cartX, cartY, cartZ);
            }
        } else if (behavior instanceof class_9879 controller && controller.method_61614()) {
            double cartX = class_3532.method_16436(partialTicks, cart.field_6038, cart.method_23317());
            double cartY = class_3532.method_16436(partialTicks, cart.field_5971, cart.method_23318());
            double cartZ = class_3532.method_16436(partialTicks, cart.field_5989, cart.method_23321());
            class_243 cartPos = controller.method_61610(partialTicks);
            return new class_243(cartPos.field_1352 - cartX, cartPos.field_1351 - cartY, cartPos.field_1350 - cartZ);
        }

        return class_243.field_1353;
    }

    public static void repositionOnContraption(
        OrientedContraptionEntity entity,
        class_4587 matrixStack,
        float partialTicks,
        AbstractContraptionEntity ridingEntity
    ) {
        class_243 pos = getContraptionOffset(entity, partialTicks, ridingEntity);
        matrixStack.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static class_243 getContraptionOffset(OrientedContraptionEntity entity, float partialTicks, AbstractContraptionEntity parent) {
        class_243 passengerPosition = parent.getPassengerPosition(entity, partialTicks);
        if (passengerPosition == null)
            return class_243.field_1353;

        double x = passengerPosition.field_1352 - class_3532.method_16436(partialTicks, entity.field_6038, entity.method_23317());
        double y = passengerPosition.field_1351 - class_3532.method_16436(partialTicks, entity.field_5971, entity.method_23318());
        double z = passengerPosition.field_1350 - class_3532.method_16436(partialTicks, entity.field_5989, entity.method_23321());

        return new class_243(x, y, z);
    }
}
