package com.zurrtum.create.client.content.decoration.encasing;

import com.zurrtum.create.client.AllCasings;
import com.zurrtum.create.client.AllCasings.Entry;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShiftEntry;
import com.zurrtum.create.client.foundation.block.connected.ConnectedTextureBehaviour;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class EncasedCTBehaviour extends ConnectedTextureBehaviour.Base {

    private final CTSpriteShiftEntry shift;

    public EncasedCTBehaviour(CTSpriteShiftEntry shift) {
        this.shift = shift;
    }

    @Override
    public boolean connectsTo(class_2680 state, class_2680 other, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        if (isBeingBlocked(state, reader, pos, otherPos, face))
            return false;
        Entry entry = AllCasings.get(state);
        Entry otherEntry = AllCasings.get(other);
        if (entry == null || otherEntry == null)
            return false;
        if (!entry.isSideValid(state, face) || !otherEntry.isSideValid(other, face))
            return false;
        return entry.getCasing() == otherEntry.getCasing();
    }

    @Override
    public CTSpriteShiftEntry getShift(class_2680 state, class_2350 direction, @Nullable class_1058 sprite) {
        return shift;
    }

}
