package com.zurrtum.create.client.content.equipment.hats;

import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.trains.schedule.hat.TrainHatInfo;
import com.zurrtum.create.client.content.trains.schedule.hat.TrainHatInfoReloadListener;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3882;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4722;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class HatFeatureRenderer<S extends class_10042, M extends class_583<? super S>> extends class_3887<S, M> {
    public HatFeatureRenderer(class_3883<S, M> context) {
        super(context);
    }

    @Override
    public void render(class_4587 ms, class_11659 queue, int light, S renderState, float limbAngle, float limbDistance) {
        HatState hatState = (HatState) renderState;
        PartialModel hat = hatState.create$getHat();
        if (hat == null)
            return;

        M entityModel = method_17165();
        ms.method_22903();

        var msr = TransformStack.of(ms);
        TrainHatInfo info = hatState.create$getHatInfo();
        class_630 lastChild;
        if (entityModel instanceof class_3882 model) {
            List<class_630> partsToHead = TrainHatInfo.getAdjustedPart(info, model.method_2838(), "");
            entityModel.method_63512().method_22703(ms);
            model.method_74046(ms);
            int size = partsToHead.size();
            for (int i = 1; i < size; i++) {
                partsToHead.get(i).method_22703(ms);
            }
            lastChild = partsToHead.get(size - 1);
        } else if (info != TrainHatInfoReloadListener.DEFAULT) {
            List<class_630> partsToHead = TrainHatInfo.getAdjustedPart(info, entityModel.method_63512(), "head");
            partsToHead.forEach(part -> part.method_22703(ms));
            lastChild = partsToHead.getLast();
        } else {
            ms.method_22909();
            return;
        }


        if (!lastChild.method_32087()) {
            class_630.class_628 cube = lastChild.field_3663.get(class_3532.method_15340(info.cubeIndex(), 0, lastChild.field_3663.size() - 1));
            ms.method_22904(info.offset().method_10216() / 16.0F, (cube.field_3644 - cube.field_3647 + info.offset().method_10214()) / 16.0F, info.offset().method_10215() / 16.0F);
            float max = Math.max(cube.field_3648 - cube.field_3645, cube.field_3646 - cube.field_3643) / 8.0F * info.scale();
            ms.method_22905(max, max, max);
        }

        ms.method_22905(1, -1, -1);
        ms.method_46416(0, -2.25F / 16.0F, 0);
        msr.rotateXDegrees(-8.5F);
        class_2680 air = class_2246.field_10124.method_9564();
        HatRenderState state = new HatRenderState(CachedBuffers.partial(hat, air), light);
        queue.method_73483(ms, class_4722.method_24074(), state);

        ms.method_22909();
    }

    public record HatRenderState(SuperByteBuffer hat, int light) implements class_11659.class_11660 {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            hat.disableDiffuse().light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
