package com.zurrtum.create.client.content.equipment.zapper;

import net.minecraft.class_1007;
import net.minecraft.class_11659;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_898;

public abstract class ShootableGadgetRenderHandler {

    protected float leftHandAnimation;
    protected float rightHandAnimation;
    protected float lastLeftHandAnimation;
    protected float lastRightHandAnimation;
    protected boolean dontReequipLeft;
    protected boolean dontReequipRight;

    public void tick() {
        lastLeftHandAnimation = leftHandAnimation;
        lastRightHandAnimation = rightHandAnimation;
        leftHandAnimation *= animationDecay();
        rightHandAnimation *= animationDecay();
    }

    public float getAnimation(boolean rightHand, float partialTicks) {
        return class_3532.method_16439(
            partialTicks,
            rightHand ? lastRightHandAnimation : lastLeftHandAnimation,
            rightHand ? rightHandAnimation : leftHandAnimation
        );
    }

    protected float animationDecay() {
        return 0.8f;
    }

    public void shoot(class_1268 hand, class_243 location) {
        class_746 player = class_310.method_1551().field_1724;
        boolean rightHand = hand == class_1268.field_5808 ^ player.method_6068() == class_1306.field_6182;
        if (rightHand) {
            rightHandAnimation = .2f;
            dontReequipRight = false;
        } else {
            leftHandAnimation = .2f;
            dontReequipLeft = false;
        }
        playSound(hand, location);
    }

    public abstract void playSound(class_1268 hand, class_243 position);

    protected abstract boolean appliesTo(class_1799 stack);

    protected abstract void transformTool(class_4587 ms, float flip, float equipProgress, float recoil, float pt);

    protected abstract void transformHand(class_4587 ms, float flip, float equipProgress, float recoil, float pt);

    public boolean onRenderPlayerHand(
        class_1799 heldItem,
        class_310 mc,
        class_898 entityRenderDispatcher,
        class_759 firstPersonRenderer,
        class_4587 ms,
        class_11659 queue,
        int light,
        float pt,
        class_1268 hand,
        float equipProgress,
        float swingProgress
    ) {
        if (!appliesTo(heldItem))
            return false;

        class_742 player = mc.field_1724;
        class_1007<class_742> playerrenderer = entityRenderDispatcher.method_74405(player);

        boolean rightHand = hand == class_1268.field_5808 ^ player.method_6068() == class_1306.field_6182;
        float recoil = rightHand ? class_3532.method_16439(pt, lastRightHandAnimation, rightHandAnimation) : class_3532.method_16439(
            pt,
            lastLeftHandAnimation,
            leftHandAnimation
        );

        if (rightHand && (rightHandAnimation > .01f || dontReequipRight))
            equipProgress = 0;
        if (!rightHand && (leftHandAnimation > .01f || dontReequipLeft))
            equipProgress = 0;

        // Render arm
        float flip = rightHand ? 1.0F : -1.0F;
        float f1 = class_3532.method_15355(swingProgress);
        float f2 = -0.3F * class_3532.method_15374(f1 * (float) Math.PI);
        float f3 = 0.4F * class_3532.method_15374(f1 * ((float) Math.PI * 2F));
        float f4 = -0.4F * class_3532.method_15374(swingProgress * (float) Math.PI);
        float f5 = class_3532.method_15374(swingProgress * swingProgress * (float) Math.PI);
        float f6 = class_3532.method_15374(f1 * (float) Math.PI);

        ms.method_22903();
        ms.method_46416(flip * (f2 + 0.64F - .1f), f3 + -0.4F + equipProgress * -0.6F, f4 + -0.72F + .3f + recoil);
        ms.method_22907(class_7833.field_40716.rotationDegrees(flip * 75.0F));
        ms.method_22907(class_7833.field_40716.rotationDegrees(flip * f6 * 70.0F));
        ms.method_22907(class_7833.field_40718.rotationDegrees(flip * f5 * -20.0F));
        ms.method_46416(flip * -1.0F, 3.6F, 3.5F);
        ms.method_22907(class_7833.field_40718.rotationDegrees(flip * 120.0F));
        ms.method_22907(class_7833.field_40714.rotationDegrees(200.0F));
        ms.method_22907(class_7833.field_40716.rotationDegrees(flip * -135.0F));
        ms.method_46416(flip * 5.6F, 0.0F, 0.0F);
        ms.method_22907(class_7833.field_40716.rotationDegrees(flip * 40.0F));
        transformHand(ms, flip, equipProgress, recoil, pt);
        class_2960 texture = player.method_52814().comp_1626().comp_3627();
        if (rightHand)
            playerrenderer.method_4220(ms, queue, light, texture, player.method_74091(class_1664.field_7570));
        else
            playerrenderer.method_4221(ms, queue, light, texture, player.method_74091(class_1664.field_7568));
        ms.method_22909();

        // Render gadget
        ms.method_22903();
        ms.method_46416(flip * (f2 + 0.64F - .1f), f3 + -0.4F + equipProgress * -0.6F, f4 + -0.72F - 0.1f + recoil);
        ms.method_22907(class_7833.field_40716.rotationDegrees(flip * f6 * 70.0F));
        ms.method_22907(class_7833.field_40718.rotationDegrees(flip * f5 * -20.0F));
        transformTool(ms, flip, equipProgress, recoil, pt);
        firstPersonRenderer.method_3233(
            player,
            heldItem,
            rightHand ? class_811.field_4322 : class_811.field_4321,
            ms,
            queue,
            light
        );
        ms.method_22909();
        return true;
    }

    public void dontAnimateItem(class_1268 hand) {
        class_746 player = class_310.method_1551().field_1724;
        boolean rightHand = hand == class_1268.field_5808 ^ player.method_6068() == class_1306.field_6182;
        dontReequipRight |= rightHand;
        dontReequipLeft |= !rightHand;
    }

}
