package com.zurrtum.create.client.content.fluids;

import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;

public class FluidFX {

    static class_5819 r = class_5819.method_43047();

    public static void splash(class_2338 pos, class_3611 fluid) {
        if (fluid == class_3612.field_15906)
            return;

        class_3610 defaultState = fluid.method_15785();
        if (defaultState == null || defaultState.method_15769()) {
            return;
        }

        class_2388 blockParticleData = new class_2388(class_2398.field_11217, defaultState.method_15759());
        class_243 center = VecHelper.getCenterOf(pos);

        for (int i = 0; i < 20; i++) {
            class_243 v = VecHelper.offsetRandomly(class_243.field_1353, r, .25f);
            particle(blockParticleData, center.method_1019(v), v);
        }

    }

    public static class_2394 getFluidParticle(FluidStack fluid) {
        return new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, fluid.getFluid(), fluid.getComponentChanges());
    }

    public static class_2394 getDrippingParticle(FluidStack fluid) {
        class_2394 particle = null;
        if (FluidHelper.isWater(fluid.getFluid()))
            particle = class_2398.field_11232;
        if (FluidHelper.isLava(fluid.getFluid()))
            particle = class_2398.field_11223;
        if (particle == null)
            particle = new FluidParticleData(AllParticleTypes.FLUID_DRIP, fluid.getFluid(), fluid.getComponentChanges());
        return particle;
    }

    public static void spawnRimParticles(class_1937 world, class_2338 pos, class_2350 side, int amount, class_2394 particle, float rimRadius) {
        class_243 directionVec = class_243.method_24954(side.method_62675());
        for (int i = 0; i < amount; i++) {
            class_243 vec = VecHelper.offsetRandomly(class_243.field_1353, r, 1).method_1029();
            vec = VecHelper.clampComponentWise(vec, rimRadius).method_18806(VecHelper.axisAlingedPlaneOf(directionVec))
                .method_1019(directionVec.method_1021(.45 + r.method_43057() / 16f));
            class_243 m = vec.method_1021(.05f);
            vec = vec.method_1019(VecHelper.getCenterOf(pos));

            world.method_8494(particle, vec.field_1352, vec.field_1351 - 1 / 16f, vec.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public static void spawnPouringLiquid(
        class_1937 world,
        class_2338 pos,
        int amount,
        class_2394 particle,
        float rimRadius,
        class_243 directionVec,
        boolean inbound
    ) {
        for (int i = 0; i < amount; i++) {
            class_243 vec = VecHelper.offsetRandomly(class_243.field_1353, r, rimRadius * .75f);
            vec = vec.method_18806(VecHelper.axisAlingedPlaneOf(directionVec)).method_1019(directionVec.method_1021(.5 + r.method_43057() / 4f));
            class_243 m = vec.method_1021(1 / 4f);
            class_243 centerOf = VecHelper.getCenterOf(pos);
            vec = vec.method_1019(centerOf);
            if (inbound) {
                vec = vec.method_1019(m);
                m = centerOf.method_1019(directionVec.method_1021(.5)).method_1020(vec).method_1021(1 / 16f);
            }
            world.method_8494(particle, vec.field_1352, vec.field_1351 - 1 / 16f, vec.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    private static void particle(class_2394 data, class_243 pos, class_243 motion) {
        world().method_8406(data, pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
    }

    private static class_1937 world() {
        return class_310.method_1551().field_1687;
    }

}
