package com.zurrtum.create.client.content.fluids.pipes.valve;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlock;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlockEntity;
import net.minecraft.class_11683;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class FluidValveRenderer extends KineticBlockEntityRenderer<FluidValveBlockEntity, FluidValveRenderer.FluidValveRenderState> {
    public FluidValveRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public FluidValveRenderState createRenderState() {
        return new FluidValveRenderState();
    }

    @Override
    public void updateRenderState(
        FluidValveBlockEntity be,
        FluidValveRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        class_2680 blockState = be.method_11010();
        state.pointer = CachedBuffers.partial(AllPartialModels.FLUID_VALVE_POINTER, blockState);
        class_2350 facing = blockState.method_11654(FluidValveBlock.FACING);
        state.yRot = class_3532.field_29847 * AngleHelper.horizontalAngle(facing);
        state.xRot = class_3532.field_29847 * (facing == class_2350.field_11036 ? 0 : facing == class_2350.field_11033 ? 180 : 90);
        class_2351 pipeAxis = FluidValveBlock.getPipeAxis(blockState);
        float pointerRotation = class_3532.method_48781(be.pointer.getValue(tickProgress), 0, -90);
        if (pipeAxis.method_10179() && getRotationAxisOf(be) == class_2351.field_11048 || pipeAxis.method_10178()) {
            state.yRot2 = class_3532.field_29847 * (90 + pointerRotation);
        } else {
            state.yRot2 = class_3532.field_29847 * pointerRotation;
        }
    }

    @Override
    protected class_1921 getRenderType(FluidValveBlockEntity be, class_2680 state) {
        return class_1921.method_23577();
    }

    @Override
    protected class_2680 getRenderedBlockState(FluidValveBlockEntity be) {
        return shaft(getRotationAxisOf(be));
    }

    public static class FluidValveRenderState extends KineticRenderState {
        public SuperByteBuffer pointer;
        public float yRot;
        public float xRot;
        public float yRot2;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            pointer.center().rotateY(yRot).rotateX(xRot).rotateY(yRot2).uncenter();
            pointer.light(lightmapCoordinates).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
