package com.zurrtum.create.client.content.kinetics.base;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public abstract class KineticBlockEntityVisual<T extends KineticBlockEntity> extends AbstractBlockEntityVisual<T> {

    public KineticBlockEntityVisual(VisualizationContext context, T blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
    }

    protected class_2351 rotationAxis() {
        return rotationAxis(blockState);
    }

    public static float rotationOffset(class_2680 state, class_2351 axis, class_2382 pos) {
        if (shouldOffset(axis, pos)) {
            return 22.5f;
        } else {
            return ICogWheel.isLargeCog(state) ? 11.25f : 0;
        }
    }

    public static boolean shouldOffset(class_2351 axis, class_2382 pos) {
        // Sum the components of the other 2 axes.
        int x = (axis == class_2351.field_11048) ? 0 : pos.method_10263();
        int y = (axis == class_2351.field_11052) ? 0 : pos.method_10264();
        int z = (axis == class_2351.field_11051) ? 0 : pos.method_10260();
        return ((x + y + z) % 2) == 0;
    }

    public static class_2351 rotationAxis(class_2680 blockState) {
        return (blockState.method_26204() instanceof IRotate irotate) ? irotate.getRotationAxis(blockState) : class_2351.field_11052;
    }
}
