package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;

public abstract class ChainConveyorShape {

    @Nullable
    public abstract class_243 intersect(class_243 from, class_243 to);

    public abstract float getChainPosition(class_243 intersection);

    protected abstract void drawOutline(class_2338 anchor, class_4587 ms, class_4588 vb);

    public abstract class_243 getVec(class_2338 anchor, float position);

    public static class ChainConveyorOBB extends ChainConveyorShape {

        public class_2338 connection;
        double yaw, pitch;
        class_238 bounds;
        class_243 pivot;
        final double radius = 0.175;
        class_265 voxelShape;

        class_243[] linePoints;

        public ChainConveyorOBB(class_2338 connection, class_243 start, class_243 end) {
            this.connection = connection;
            class_243 diff = end.method_1020(start);
            double d = diff.method_1033();
            double dxz = diff.method_18805(1, 0, 1).method_1033();
            yaw = class_3532.field_29848 * class_3532.method_15349(diff.field_1352, diff.field_1350);
            pitch = class_3532.field_29848 * class_3532.method_15349(-diff.field_1351, dxz);
            bounds = new class_238(start, start).method_1012(0, 0, d).method_1009(radius, radius, 0);
            pivot = start;
            voxelShape = class_259.method_1078(bounds);
        }

        @Override
        public class_243 intersect(class_243 from, class_243 to) {
            from = counterTransform(from);
            to = counterTransform(to);

            class_243 result = bounds.method_992(from, to).orElse(null);
            if (result == null)
                return null;

            result = transform(result);
            return result;
        }

        private class_243 counterTransform(class_243 from) {
            from = from.method_1020(pivot);
            from = VecHelper.rotate(from, -yaw, class_2351.field_11052);
            from = VecHelper.rotate(from, -pitch, class_2351.field_11048);
            from = from.method_1019(pivot);
            return from;
        }

        private class_243 transform(class_243 result) {
            result = result.method_1020(pivot);
            result = VecHelper.rotate(result, pitch, class_2351.field_11048);
            result = VecHelper.rotate(result, yaw, class_2351.field_11052);
            result = result.method_1019(pivot);
            return result;
        }

        @Override
        public void drawOutline(class_2338 anchor, class_4587 ms, class_4588 vb) {
            TransformStack.of(ms).translate(pivot).rotateYDegrees((float) yaw).rotateXDegrees((float) pitch).translateBack(pivot);
            TrackBlockOutline.renderShape(voxelShape, ms, vb, null);
        }

        @Override
        public float getChainPosition(class_243 intersection) {
            int dots = (int) Math.round(class_243.method_24954(connection).method_1033() - 3);
            double length = bounds.method_17941();
            double selection = Math.min(bounds.method_17941(), intersection.method_1022(pivot));

            double margin = length - dots;
            selection = class_3532.method_15350(selection - margin, 0, length - margin * 2);
            selection = Math.round(selection);

            return (float) (selection + margin + 0.025);
        }

        @Override
        public class_243 getVec(class_2338 anchor, float position) {
            float x = (float) bounds.method_1005().field_1352;
            float y = (float) bounds.method_1005().field_1351;
            class_243 from = new class_243(x, y, bounds.field_1321);
            class_243 to = new class_243(x, y, bounds.field_1324);
            class_243 point = from.method_35590(to, class_3532.method_15350(position / from.method_1022(to), 0, 1));
            point = transform(point);
            return point.method_1019(class_243.method_24954(anchor));
        }
    }

    public static class ChainConveyorBB extends ChainConveyorShape {

        class_243 lb, rb;
        final double radius = 0.875;
        class_238 bounds;

        public ChainConveyorBB(class_243 center) {
            lb = center.method_1031(0, 0, 0);
            rb = center.method_1031(0, 0.5, 0);
            bounds = new class_238(lb, rb).method_1009(1, 0, 1);
        }

        @Override
        public class_243 intersect(class_243 from, class_243 to) {
            return bounds.method_992(from, to).orElse(null);
        }

        @Override
        public void drawOutline(class_2338 anchor, class_4587 ms, class_4588 vb) {
            TrackBlockOutline.renderShape(AllShapes.CHAIN_CONVEYOR_INTERACTION, ms, vb, null);
        }

        @Override
        public float getChainPosition(class_243 intersection) {
            class_243 diff = bounds.method_1005().method_1020(intersection);
            float angle = (float) (class_3532.field_29848 * class_3532.method_15349(diff.field_1352, diff.field_1350) + 360 + 180) % 360;
            float rounded = Math.round(angle / 45) * 45f;
            return rounded;
        }

        @Override
        public class_243 getVec(class_2338 anchor, float position) {
            class_243 point = bounds.method_1005();
            point = point.method_1019(VecHelper.rotate(new class_243(0, 0, radius), position, class_2351.field_11052));
            return point.method_1019(class_243.method_24954(anchor)).method_1031(0, -.125, 0);
        }

    }

}
