package com.zurrtum.create.client.content.kinetics.crafter;

import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity.Phase;
import com.zurrtum.create.content.kinetics.crafter.RecipeGridHandler.GroupedItems;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock.HORIZONTAL_FACING;

public class MechanicalCrafterRenderer implements class_827<MechanicalCrafterBlockEntity, MechanicalCrafterRenderer.MechanicalCrafterRenderState> {
    protected final class_10442 itemModelManager;

    public MechanicalCrafterRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    public MechanicalCrafterRenderState method_74335() {
        return new MechanicalCrafterRenderState();
    }

    @Override
    public void updateRenderState(
        MechanicalCrafterBlockEntity be,
        MechanicalCrafterRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        class_1937 world = be.method_10997();
        Phase phase = be.phase;
        state.item = createItemState(itemModelManager, be, world, state.field_62674, phase, tickProgress);
        class_2350 facing = state.field_62674.method_11654(HORIZONTAL_FACING);
        float yRot = AngleHelper.horizontalAngle(facing);
        if (state.item != null) {
            class_243 vec = class_243.method_24954(facing.method_62675()).method_1021(.58).method_1031(.5, .5, .5);
            if (phase == Phase.EXPORTING) {
                class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(state.field_62674);
                float progress = class_3532.method_15363((1000 - be.countDown + be.getCountDownSpeed() * tickProgress) / 1000f, 0, 1);
                vec = vec.method_1019(class_243.method_24954(targetDirection.method_62675()).method_1021(progress * .75f));
            }
            state.offset = vec;
            state.yRot = class_3532.field_29847 * yRot;
        }
        state.layer = class_1921.method_23577();
        if (!VisualizationManager.supportsVisualization(world)) {
            state.cogwheel = CogwheelRenderState.create(be, state.field_62674, state.field_62673, facing);
        }
        float xRot = state.field_62674.method_11654(MechanicalCrafterBlock.POINTING).getXRotation();
        state.upRot = (float) ((yRot + 90) / 180 * Math.PI);
        state.eastRot = (float) ((xRot) / 180 * Math.PI);
        if ((be.covered || phase != Phase.IDLE) && phase != Phase.CRAFTING && phase != Phase.INSERTING) {
            state.lid = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_LID, state.field_62674);
        }
        class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(state.field_62674);
        if (MechanicalCrafterBlock.isValidTarget(world, state.field_62673.method_10093(targetDirection), state.field_62674)) {
            state.belt = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_BELT, state.field_62674);
            state.frame = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_BELT_FRAME, state.field_62674);
            if (phase == Phase.EXPORTING) {
                int textureIndex = (int) ((be.getCountDownSpeed() / 128f * AnimationTickHolder.getTicks()));
                state.beltScroll = (textureIndex % 4) / 4f;
            }
        } else {
            state.arrow = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_ARROW, state.field_62674);
        }
    }

    public static MechanicalCrafterItemRenderState createItemState(
        class_10442 itemModelManager,
        MechanicalCrafterBlockEntity be,
        class_1937 world,
        class_2680 blockState,
        Phase phase,
        float tickProgress
    ) {
        if (phase == Phase.IDLE) {
            return MechanicalCrafterSingleItemRenderState.create(itemModelManager, be, world);
        }
        if (phase == Phase.CRAFTING) {
            return MechanicalCrafterCraftingItemRenderState.create(itemModelManager, be, world, tickProgress);
        }
        return MechanicalCrafterPhaseItemRenderState.create(itemModelManager, be, world, blockState, phase);
    }

    @Override
    public void render(MechanicalCrafterRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
        if (state.item != null) {
            matrices.method_61958(state.offset);
            matrices.method_22905(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotation(state.yRot));
            state.item.render(queue, matrices, state.field_62676);
        }
    }

    private SuperByteBuffer renderAndTransform(PartialModel renderBlock, class_2680 crafterState) {
        SuperByteBuffer buffer = CachedBuffers.partial(renderBlock, crafterState);
        float xRot = crafterState.method_11654(MechanicalCrafterBlock.POINTING).getXRotation();
        float yRot = AngleHelper.horizontalAngle(crafterState.method_11654(HORIZONTAL_FACING));
        buffer.rotateCentered((float) ((yRot + 90) / 180 * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float) ((xRot) / 180 * Math.PI), class_2350.field_11034);
        return buffer;
    }

    public static class MechanicalCrafterRenderState extends class_11954 implements class_11659.class_11660 {
        public class_243 offset;
        public float yRot;
        public MechanicalCrafterItemRenderState item;
        public class_1921 layer;
        public CogwheelRenderState cogwheel;
        public float upRot;
        public float eastRot;
        public SuperByteBuffer lid;
        public SuperByteBuffer belt;
        public SuperByteBuffer frame;
        public float beltScroll;
        public SuperByteBuffer arrow;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (cogwheel != null) {
                cogwheel.render(matricesEntry, vertexConsumer, field_62676);
            }
            if (lid != null) {
                lid.rotateCentered(upRot, class_2350.field_11036).rotateCentered(eastRot, class_2350.field_11034).light(field_62676)
                    .renderInto(matricesEntry, vertexConsumer);
            }
            if (belt != null) {
                belt.rotateCentered(upRot, class_2350.field_11036).rotateCentered(eastRot, class_2350.field_11034);
                if (beltScroll != 0) {
                    belt.shiftUVtoSheet(AllSpriteShifts.CRAFTER_THINGIES, beltScroll, 0, 1);
                }
                belt.light(field_62676).renderInto(matricesEntry, vertexConsumer);
                frame.rotateCentered(upRot, class_2350.field_11036).rotateCentered(eastRot, class_2350.field_11034).light(field_62676)
                    .renderInto(matricesEntry, vertexConsumer);
            } else {
                arrow.rotateCentered(upRot, class_2350.field_11036).rotateCentered(eastRot, class_2350.field_11034).light(field_62676)
                    .renderInto(matricesEntry, vertexConsumer);
            }
        }
    }

    public record CogwheelRenderState(
        SuperByteBuffer cogwheel, float angle, class_2350 direction, Color color, float upAngle
    ) {
        public static CogwheelRenderState create(MechanicalCrafterBlockEntity be, class_2680 blockState, class_2338 pos, class_2350 facing) {
            SuperByteBuffer model = CachedBuffers.partial(AllPartialModels.SHAFTLESS_COGWHEEL, blockState);
            class_2351 axis = facing.method_10166();
            float angle = KineticBlockEntityRenderer.getAngleForBe(be, pos, axis);
            class_2350 direction = class_2350.method_10169(axis, class_2350.class_2352.field_11056);
            float upAngle = axis != class_2351.field_11048 ? 0 : class_3532.field_29845;
            Color color = KineticBlockEntityRenderer.getColor(be);
            return new CogwheelRenderState(model, angle, direction, color, upAngle);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, int light) {
            cogwheel.rotateCentered(angle, direction).rotateCentered(upAngle, class_2350.field_11036).rotateCentered(class_3532.field_29845, class_2350.field_11034)
                .light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    public interface MechanicalCrafterItemRenderState {
        void render(class_11659 queue, class_4587 ms, int light);
    }

    public record MechanicalCrafterSingleItemRenderState(
        float offset, float yRot, class_10444 state
    ) implements MechanicalCrafterItemRenderState {
        public static MechanicalCrafterSingleItemRenderState create(class_10442 itemModelManager, MechanicalCrafterBlockEntity be, class_1937 world) {
            class_1799 stack = be.getInventory().getStack();
            if (stack.method_7960()) {
                return null;
            }
            float offset = -1 / 256f;
            float yRot = class_3532.field_29847 * 180;
            class_10444 state = new class_10444();
            state.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
            return new MechanicalCrafterSingleItemRenderState(offset, yRot, state);
        }

        @Override
        public void render(class_11659 queue, class_4587 ms, int light) {
            ms.method_22903();
            ms.method_46416(0, 0, offset);
            ms.method_22907(class_7833.field_40716.rotation(yRot));
            state.method_65604(ms, queue, light, class_4608.field_21444, 0);
            ms.method_22909();
        }
    }

    public record MechanicalCrafterCraftingItemRenderState(
        float scale, class_243 centering, List<GridItemRenderState> before, float yRot, float zRot, float upScaling, float downScaling,
        List<class_10444> states
    ) implements MechanicalCrafterItemRenderState {
        public static MechanicalCrafterCraftingItemRenderState create(
            class_10442 itemModelManager,
            MechanicalCrafterBlockEntity be,
            class_1937 world,
            float tickProgress
        ) {
            GroupedItems items = be.groupedItemsBeforeCraft;
            boolean beforeEmpty = items.grid.isEmpty();
            boolean itemsEmpty = be.groupedItems.grid.isEmpty();
            if (beforeEmpty && itemsEmpty) {
                return null;
            }
            float yRot = class_3532.field_29847 * 180;
            float value = be.countDown - be.getCountDownSpeed() * tickProgress;
            float scale;
            class_243 centering;
            List<GridItemRenderState> before;
            if (beforeEmpty) {
                scale = 0;
                centering = null;
                before = null;
            } else {
                items.calcStats();
                float progress = class_3532.method_15363((2000 - value) / 1000f, 0, 1);
                float earlyProgress = class_3532.method_15363(progress * 2, 0, 1);
                scale = 1 - class_3532.method_15363(progress * 2 - 1, 0, 1);
                centering = new class_243(-items.minX + (-items.width + 1) / 2f, -items.minY + (-items.height + 1) / 2f, 0).method_1021(earlyProgress)
                    .method_18805(0.5, 0.5, 1);
                float distance = .5f + (-4 * (progress - .5f) * (progress - .5f) + 1) * .25f;
                boolean onlyRenderFirst = be.countDown < 1000;
                before = new ArrayList<>(items.grid.size());
                items.grid.forEach((pair, stack) -> {
                    if (onlyRenderFirst && (pair.getFirst() != 0 || pair.getSecond() != 0)) {
                        return;
                    }
                    int x = pair.getFirst();
                    int y = pair.getSecond();
                    float offsetX = x * distance;
                    float offsetY = y * distance;
                    float offsetZ = (x + y * 3) / 1024f;
                    class_10444 state = new class_10444();
                    state.field_55337 = class_811.field_4319;
                    itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
                    before.add(new GridItemRenderState(state, offsetX, offsetY, offsetZ));
                });
            }
            float zRot, upScaling, downScaling;
            List<class_10444> states;
            if (itemsEmpty) {
                zRot = upScaling = downScaling = 0;
                states = null;
            } else {
                float progress = class_3532.method_15363((1000 - value) / 1000f, 0, 1);
                float earlyProgress = class_3532.method_15363(progress * 2, 0, 1);
                zRot = class_3532.field_29847 * (earlyProgress * 2 * 360);
                upScaling = earlyProgress * 1.125f;
                downScaling = 1 + (1 - class_3532.method_15363(progress * 2 - 1, 0, 1)) * .125f;
                items = be.groupedItems;
                states = new ArrayList<>(items.grid.size());
                items.grid.forEach((pair, stack) -> {
                    if (pair.getFirst() != 0 || pair.getSecond() != 0) {
                        return;
                    }
                    class_10444 state = new class_10444();
                    state.field_55337 = class_811.field_4319;
                    itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
                    states.add(state);
                });
            }
            return new MechanicalCrafterCraftingItemRenderState(scale, centering, before, yRot, zRot, upScaling, downScaling, states);
        }

        @Override
        public void render(class_11659 queue, class_4587 ms, int light) {
            if (before != null) {
                ms.method_22903();
                ms.method_22905(scale, scale, scale);
                ms.method_61958(centering);
                for (GridItemRenderState state : before) {
                    state.render(queue, ms, yRot, light);
                }
                ms.method_22909();
            }
            if (states != null) {
                ms.method_22907(class_7833.field_40718.rotation(zRot));
                ms.method_22905(upScaling, upScaling, upScaling);
                ms.method_22905(downScaling, downScaling, downScaling);
                for (class_10444 state : states) {
                    ms.method_22903();
                    ms.method_22907(class_7833.field_40716.rotation(yRot));
                    state.method_65604(ms, queue, light, class_4608.field_21444, 0);
                    ms.method_22909();
                }
            }
        }
    }

    public record MechanicalCrafterPhaseItemRenderState(List<GridItemRenderState> states, float yRot) implements MechanicalCrafterItemRenderState {
        public static MechanicalCrafterPhaseItemRenderState create(
            class_10442 itemModelManager,
            MechanicalCrafterBlockEntity be,
            class_1937 world,
            class_2680 blockState,
            Phase phase
        ) {
            Map<Pair<Integer, Integer>, class_1799> grid = be.groupedItems.grid;
            if (grid.isEmpty()) {
                return null;
            }
            float distance = .5f;
            boolean onlyRenderFirst = phase == Phase.INSERTING;
            boolean isExporting = phase == Phase.EXPORTING && blockState.method_28498(MechanicalCrafterBlock.POINTING);
            Pointing pointing = isExporting ? blockState.method_11654(MechanicalCrafterBlock.POINTING) : null;
            float yRot = class_3532.field_29847 * 180;
            List<GridItemRenderState> states = new ArrayList<>(grid.size());
            grid.forEach((pair, stack) -> {
                if (onlyRenderFirst && (pair.getFirst() != 0 || pair.getSecond() != 0)) {
                    return;
                }
                int x = pair.getFirst();
                int y = pair.getSecond();
                float offsetX = x * distance;
                float offsetY = y * distance;
                int value = x + y * 3;
                if (pointing != null) {
                    switch (pointing) {
                        case UP -> value -= 9;
                        case LEFT -> value += 18;
                        case RIGHT -> value -= 18;
                        case DOWN -> value += 9;
                    }
                }
                float offsetZ = value / 1024f;
                class_10444 state = new class_10444();
                state.field_55337 = class_811.field_4319;
                itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
                states.add(new GridItemRenderState(state, offsetX, offsetY, offsetZ));
            });
            return new MechanicalCrafterPhaseItemRenderState(states, yRot);
        }

        @Override
        public void render(class_11659 queue, class_4587 ms, int light) {
            for (GridItemRenderState state : states) {
                state.render(queue, ms, yRot, light);
            }
        }
    }

    public record GridItemRenderState(class_10444 state, float offsetX, float offsetY, float offsetZ) {
        public void render(class_11659 queue, class_4587 ms, float yRot, int light) {
            ms.method_22903();
            ms.method_46416(offsetX, offsetY, 0);
            ms.method_22907(class_7833.field_40716.rotation(yRot));
            ms.method_46416(0, 0, offsetZ);
            state.method_65604(ms, queue, light, class_4608.field_21444, 0);
            ms.method_22909();
        }
    }
}
