package com.zurrtum.create.client.content.kinetics.crank;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlockEntity;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlock;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlockEntity;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5614;

public class ValveHandleRenderer extends HandCrankRenderer {
    public ValveHandleRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public float getIndependentAngle(HandCrankBlockEntity be, float partialTicks) {
        return getValveHandleIndependentAngle((ValveHandleBlockEntity) be, partialTicks);
    }

    public static float getValveHandleIndependentAngle(ValveHandleBlockEntity be, float partialTicks) {
        if (be.inUse == 0 && be.source != null && be.getSpeed() != 0)
            return AngleHelper.deg(KineticBlockEntityRenderer.getAngleForBe(be, be.method_11016(), KineticBlockEntityRenderer.getRotationAxisOf(be)));

        int step = be.method_11010().method_28500(ValveHandleBlock.FACING).orElse(class_2350.field_11035).method_10171().method_10181();

        return (be.inUse > 0 && be.totalUseTicks > 0 ? class_3532.method_48781(
            Math.min(
                be.totalUseTicks,
                be.totalUseTicks - be.inUse + partialTicks
            ) / (float) be.totalUseTicks,
            be.startAngle,
            be.targetAngle
        ) : be.targetAngle) * (be.backwards ? -1 : 1) * step;
    }

    @Override
    public SuperByteBuffer getRenderedHandle(class_2680 blockState) {
        return CachedBuffers.block(blockState);
    }

    @Override
    public boolean shouldRenderShaft() {
        return false;
    }
}
