package com.zurrtum.create.client.content.kinetics.simpleRelays.encased;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import net.minecraft.class_11683;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class EncasedCogRenderer extends KineticBlockEntityRenderer<SimpleKineticBlockEntity, EncasedCogRenderer.EncasedCogRenderState> {
    private final boolean large;

    public static EncasedCogRenderer small(class_5614.class_5615 context) {
        return new EncasedCogRenderer(context, false);
    }

    public static EncasedCogRenderer large(class_5614.class_5615 context) {
        return new EncasedCogRenderer(context, true);
    }

    public EncasedCogRenderer(class_5614.class_5615 context, boolean large) {
        super(context);
        this.large = large;
    }

    @Override
    public EncasedCogRenderState createRenderState() {
        return new EncasedCogRenderState();
    }

    @Override
    public void updateRenderState(
        SimpleKineticBlockEntity be,
        EncasedCogRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        state.shaftAngle = large ? BracketedKineticBlockEntityRenderer.getAngleForLargeCogShaft(be, state.axis) : state.angle;
        if (state.blockState.get(EncasedCogwheelBlock.TOP_SHAFT, false)) {
            state.top = CachedBuffers.partialFacing(
                AllPartialModels.SHAFT_HALF, state.blockState, switch (state.axis) {
                    case Y -> class_2350.field_11036;
                    case Z -> class_2350.field_11035;
                    case X -> class_2350.field_11034;
                }
            );
        }
        if (state.blockState.get(EncasedCogwheelBlock.BOTTOM_SHAFT, false)) {
            state.bottom = CachedBuffers.partialFacing(
                AllPartialModels.SHAFT_HALF, state.blockState, switch (state.axis) {
                    case Y -> class_2350.field_11033;
                    case Z -> class_2350.field_11043;
                    case X -> class_2350.field_11039;
                }
            );
        }
    }

    @Override
    protected class_1921 getRenderType(SimpleKineticBlockEntity be, class_2680 state) {
        return class_1921.method_23577();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(SimpleKineticBlockEntity be, EncasedCogRenderState state) {
        return CachedBuffers.partialFacingVertical(
            large ? AllPartialModels.SHAFTLESS_LARGE_COGWHEEL : AllPartialModels.SHAFTLESS_COGWHEEL,
            state.blockState,
            state.direction
        );
    }

    public static class EncasedCogRenderState extends KineticRenderState {
        public float shaftAngle;
        public SuperByteBuffer top;
        public SuperByteBuffer bottom;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            if (top != null) {
                top.light(lightmapCoordinates);
                top.rotateCentered(shaftAngle, direction);
                top.color(color);
                top.renderInto(matricesEntry, vertexConsumer);
            }
            if (bottom != null) {
                bottom.light(lightmapCoordinates);
                bottom.rotateCentered(shaftAngle, direction);
                bottom.color(color);
                bottom.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}
