package com.zurrtum.create.client.content.logistics;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstancerProvider;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.transform.Translate;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.util.math.*;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

import java.util.function.Consumer;

public class FlapStuffs {
    public static final int FLAP_COUNT = 4;
    public static final float X_OFFSET = 0.075f / 16f;
    public static final float SEGMENT_STEP = -3.05f / 16f;
    public static final class_243 TUNNEL_PIVOT = VecHelper.voxelSpace(0, 10, 1f);
    public static final class_243 FUNNEL_PIVOT = VecHelper.voxelSpace(0, 10, 9.5f);

    public static FlapsRenderState getFlapsRenderState(
        SuperByteBuffer flapBuffer,
        class_243 pivot,
        class_2350 funnelFacing,
        float flapness,
        float zOffset,
        int light
    ) {
        float horizontalAngle = class_3532.field_29847 * AngleHelper.horizontalAngle(funnelFacing.method_10153());
        float[] angles = new float[FLAP_COUNT];
        for (int segment = 0; segment < FLAP_COUNT; segment++) {
            angles[segment] = class_3532.field_29847 * flapAngle(flapness, segment);
        }
        class_4587.class_4665[] entries = new class_4587.class_4665[FLAP_COUNT];
        return new FlapsRenderState(flapBuffer, pivot, zOffset, light, horizontalAngle, angles, entries);
    }

    public static float flapAngle(float flapness, int segment) {
        float intensity = segment == 3 ? 1.5f : segment + 1;
        float abs = Math.abs(flapness);
        float flapAngle = class_3532.method_15374((float) ((1 - abs) * Math.PI * intensity)) * 30 * flapness;
        if (flapness < 0)
            flapAngle *= .5f;
        return flapAngle;
    }

    public static Matrix4f commonTransform(class_2338 visualPosition, class_2350 side, float baseZOffset) {
        float horizontalAngle = AngleHelper.horizontalAngle(side.method_10153());

        return new Matrix4f().translate(visualPosition.method_10263(), visualPosition.method_10264(), visualPosition.method_10260())
            .translate(Translate.CENTER, Translate.CENTER, Translate.CENTER).rotateY(class_3532.field_29847 * horizontalAngle)
            .translate(-Translate.CENTER, -Translate.CENTER, -Translate.CENTER).translate(X_OFFSET, 0, baseZOffset);
    }

    public static class Visual {
        private final TransformedInstance[] flaps;

        private final Matrix4f commonTransform = new Matrix4f();
        private final class_243 pivot;

        public Visual(InstancerProvider instancerProvider, Matrix4fc commonTransform, class_243 pivot, Model flapModel) {
            this.pivot = pivot;
            this.commonTransform.set(commonTransform).translate((float) pivot.field_1352, (float) pivot.field_1351, (float) pivot.field_1350);

            flaps = new TransformedInstance[FLAP_COUNT];

            instancerProvider.instancer(InstanceTypes.TRANSFORMED, flapModel).createInstances(flaps);
        }

        public void update(float f) {
            for (int segment = 0; segment < FLAP_COUNT; segment++) {
                var flap = flaps[segment];

                flap.setTransform(commonTransform).rotateXDegrees(flapAngle(f, segment)).translateBack(pivot).translate(segment * SEGMENT_STEP, 0, 0)
                    .setChanged();
            }
        }

        public void delete() {
            for (TransformedInstance flap : flaps) {
                flap.delete();
            }
        }

        public void updateLight(int light) {
            for (TransformedInstance flap : flaps) {
                flap.light(light).setChanged();
            }
        }

        public void collectCrumblingInstances(Consumer<Instance> consumer) {
            for (TransformedInstance flap : flaps) {
                consumer.accept(flap);
            }
        }
    }

    public record FlapsRenderState(
        SuperByteBuffer model, class_243 pivot, float zOffset, int light, float horizontalAngle, float[] angles, class_4587.class_4665[] entries
    ) implements class_11659.class_11660 {
        public void render(class_1921 layer, class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotation(horizontalAngle));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            matrices.method_46416(X_OFFSET, 0, zOffset);
            for (int segment = 0; segment < FLAP_COUNT; segment++) {
                matrices.method_22903();
                matrices.method_22904(pivot.field_1352, pivot.field_1351, pivot.field_1350);
                matrices.method_22907(class_7833.field_40714.rotation(angles[segment]));
                matrices.method_22904(-pivot.field_1352, -pivot.field_1351, -pivot.field_1350);
                entries[segment] = matrices.method_23760().method_56822();
                matrices.method_22909();
                matrices.method_46416(SEGMENT_STEP, 0, 0);
            }
            matrices.method_22909();
            queue.method_73483(matrices, layer, this);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (int segment = 0; segment < FLAP_COUNT; segment++) {
                model.light(light).renderInto(entries[segment], vertexConsumer);
            }
        }
    }
}
