package com.zurrtum.create.client.content.logistics.chute;

import com.zurrtum.create.client.content.logistics.chute.ChuteRenderer.ChuteItemRenderState;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.chute.SmartChuteBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class SmartChuteRenderer extends SmartBlockEntityRenderer<SmartChuteBlockEntity, SmartChuteRenderer.SmartChuteRenderState> {
    public SmartChuteRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public SmartChuteRenderState createRenderState() {
        return new SmartChuteRenderState();
    }

    @Override
    public void updateRenderState(
        SmartChuteBlockEntity be,
        SmartChuteRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_1799 item = be.getItem();
        if (item.method_7960()) {
            return;
        }
        float itemPosition = be.itemPosition.getValue(tickProgress);
        if (itemPosition > 0) {
            return;
        }
        state.item = ChuteItemRenderState.create(itemModelManager, item, itemPosition, be.method_10997());
    }

    @Override
    public void render(SmartChuteRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.render(state, matrices, queue, cameraState);
        if (state.item != null) {
            state.item.render(matrices, queue, state.lightmapCoordinates);
        }
    }

    public static class SmartChuteRenderState extends SmartRenderState {
        public ChuteItemRenderState item;
    }
}
